<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p3="http://www.sec.gov/edgar/sbse_drp">

	<xsl:template name="drp4_bankruptcySipc">
		<xsl:if test="count(p:bankruptcySipcDrpInfo/p3:bankruptcyDrp) &gt; 0">
			<h1>BANKRUPTCY /  SIPC DISCLOSURE REPORTING PAGE (SBSE)</h1>
			<h4 class="title1" style="font-style:italic">GENERAL INSTRUCTIONS</h4>
			<div class="information">
				<p>
					You must provide a valid response to each question on every section of this DRP before 
					any of your information can be saved. Invalid or incomplete responses will prevent you 
					from closing the DRP with your information saved. It is recommended that you consult 
					the Print Form of this DRP to make sure you have gathered all the required information 
					before beginning your entry of information online.			
				</p>			
			</div>

			<xsl:call-template name="sbse_drp4_bankruptcySipc"/>
		</xsl:if>
	</xsl:template>
	
	<!--Child templates for SBSE -->
	<xsl:template name="sbse_drp4_bankruptcySipc">
		<xsl:for-each select="p:bankruptcySipcDrpInfo/p3:bankruptcyDrp">
			<xsl:call-template name="sbse_drp4_general"/>
			<xsl:call-template name="sbse_drp4_part1"/>
			
			<xsl:if test="contains(p3:drpFiledFor, 'Applicant')">
				<xsl:call-template name="sbse_drp4_applicantGeneral"/>
				<xsl:for-each select="p3:applicant/p3:appBankruptcySipcDrpDetails">
					<xsl:call-template name="sbse_drp4_part2"/>
				</xsl:for-each>
			</xsl:if>

			<xsl:if test="contains(p3:drpFiledFor, 'affiliate')">	
			<xsl:for-each select="p3:controlAffiliate">		
				<xsl:call-template name="sbse_drp4_controlAffiliateGeneral"/>
				<xsl:if test="p3:controlAffiliateDetails/p3:isSubmittedToCRD = 'N'">
					<xsl:for-each select="p3:affBankruptcySipcDrpDetails">
						<xsl:call-template name="sbse_drp4_part2"/>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
			</xsl:if>
			
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="sbse_drp4_controlAffiliateGeneral">
		<h4 class="title2">BD DRP - CONTROL AFFILIATE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					CRD NUMBER
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:crdNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					UIC NUMBER (if any)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:uicNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					This <em>Control Affiliate</em> is
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType = 'Firm'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType = 'Individual'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Individual							
				</td>
			</tr>
			<tr>
				<td class="label">
					This <em>Control Affiliate</em> is Registered
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType = 'Firm'">
				<tr>
					<td class="label">
						NAME 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:nameOfFirm"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType = 'Individual'">
				<tr>
					<td class="label">
						Name of Control <em>Affiliate Individual</em> (CAI)
					</td>
					<td>
						&#160;
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Prefix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:prefix"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Last Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:lastName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						First Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:firstName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Middle Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:middleName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Suffix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:suffix"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning the 
						<em>control affiliate</em> from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'N'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No	
					</td>
				</tr>
				<xsl:if test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'no longer associated')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The <em>control affiliate(s)</em> are no longer associated with the SBS Entity.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'is registered or has submitted')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved in the <em>control affiliate's</em> favor. <br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'ten years ago')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.				
						</td>
					</tr>
					<xsl:if test="contains(p3:applicant/p3:drpRemovalReason , 'error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:applicant/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					B. If the <em>control affiliate</em> is registered through the CRD, has the <em>control 
					affiliate</em> submitted a DRP (with Form U-4) or DRP (BD) to the CRD System for the event? 
					If the answer is "Yes," no other information on this DRP must be provided: If "No," complete Part II. 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Note: The completion of this Form does not relieve the 
				<em>control affiliate</em> of its obligation to update 
				its CRD records.
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp4_applicantGeneral">
		<h4 class="title2">Applicant</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Name of <em>Applicant</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:applicant/p3:nameOfApplicant"/>
					</div>
				</td>
			</tr>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously 
						filed DRP concerning the applicant from the record?
					</td>
					<td>
					<xsl:choose>
						<xsl:when test="p3:applicant/p3:isToRemove = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:applicant/p3:isToRemove = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
					</td>
				</tr>
				<xsl:if test="p3:applicant/p3:isToRemove = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'proceeding previously')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved in the applicant's favor.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'ten years')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.				
						</td>
					</tr>
					<xsl:if test="contains(p3:applicant/p3:drpRemovalReason , 'error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:applicant/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</table>	
	</xsl:template>
	<xsl:template name="sbse_drp4_general">
		<!-- VARIABLES BEGIN -->
		<xsl:variable name="sbse_drp4_respond_14i1">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test="contains(., '(1)')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp4_respond_14i2">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test="contains(., '(2)')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>	
		</xsl:variable>
		<!-- VARIABLES END -->
		<table role="presentation">
			<tr>
				<td class="label">
					This Disclosure Reporting Page [DRP (SBSE)] is an an [ ] INITIAL <b><em>OR</em></b>
					[ ] AMENDED response to report details for affirmative responses to <b><em>Questions 14I</em></b> on Form SBSE; 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED				
				</td>
			</tr>
			<tr>
				<td class="label">
					Check item(s) being responded to:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						14I In the past ten years has the applicant or a <em>control affiliate</em> of the applicant 
						ever been a securities firm or a <em>control affiliate</em> of a securities firm that:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp4_respond_14i1 , '(1)')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) has been the subject of a bankruptcy petition?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp4_respond_14i2 , '(2)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) has had a trustee appointed or a direct payment procedure initiated under the Securities Investor Protection Act								
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Use a separate DRP for each event or <em>proceeding</em>. An event or <em>proceeding</em> 
				may be reported for more than one person or entity using one DRP. File with a completed Execution Page.
				<br/><br/>			
				It is not a requirement that documents be provided for each event or <em>proceeding</em>. 
				Should they be provided, they will not be accepted as disclosure in lieu of answering the questions on this DRP.
				<br/><br/>			
				If a <em>control affiliate</em> is an individual or organization registered through CRD, 
				such <em>control affiliate</em> need only complete Part I of the applicant's appropriate 
				DRP (SBSE). Details of the event must be submitted on the <em>control affiliate</em>'s 
				appropriate DRP (BD) or DRP (U-4). If a <em>control affiliate</em> is an individual or 
				organization not registered through the CRD, provide complete answers to all the items on 
				the applicant's appropriate DRP (SBSE). The completion of this DRP does not relieve the 
				<em>control affiliate</em> of its obligation to update its CRD records. 		
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp4_part1">
		<h4 class="title1">PART I</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>person</em> or entity for whom this DRP (SBSE) is being filed is: 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'Applicant') and not(contains(p3:drpFiledFor, 'affiliate'))">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;The <em>Applicant</em><br/>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'and one or more')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;<em>Applicant</em> and one or more <em>control affiliate(s)</em><br/>	
					<xsl:choose>
						<xsl:when test="not(contains(p3:drpFiledFor, 'Applicant'))">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;One or more <em>control affiliate(s)</em>
				</td>
			</tr>
		</table>
			
		<div class="information">
			<p>
				If this DRP is being filed for a <em>control affiliate</em>, give the full name 
				of the <em>control affiliate</em> below (for individuals, Last name, First name, 
				Middle name). If the <em>control affiliate</em> is registered with the CRD, provide 
				the CRD number. If not, indicate "non-registered" by checking the appropriate checkbox.			
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp4_part2">
		<h4 class="title2">PART II</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					1. Action Type: (check appropriate item) 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:actionType , 'Bankruptcy')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Bankruptcy<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:actionType , 'Declaration')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Declaration	<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:actionType , 'Receivership')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Receivership<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:actionType , 'Compromise')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Compromise	<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:actionType , 'Liquidated')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Liquidated<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:actionType , 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other													
				</td>
			</tr>
			<xsl:if test="contains(p3:actionType , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please specify
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:actionTypeOtherDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					2. Action Date (MM/DD/YYYY) 
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:actionDate/p1:date"/>
					</div>
				</td>
			</tr>
			<xsl:if test="count(p3:actionDate/p1:date) &gt; 0">
				<tr>
					<td class="label">
						<blockquote>
							Specify if Action Date is Exact or needs an Explanation
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:actionDate/p1:exactOrExplanation = 'Exact'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact
						<xsl:choose>
							<xsl:when test="p3:actionDate/p1:exactOrExplanation = 'Explanation'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation					
					</td>
				</tr>
				<xsl:if test="p3:actionDate/p1:exactOrExplanation = 'Explanation'">
					<tr>
						<td class="label">
							<blockquote>
								If not exact, provide explanation:
							</blockquote> 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:actionDate/p1:explanationInfo"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					3.  If the financial action relates to an organization over which the <em>applicant</em> 
					or the <em>control affiliate</em> exercise(d) control, enter organization name and the applicant's 
					or control affiliate’s position, title or relationship: 
				</td>
				<td>
					&#160;
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Organization Name
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:organizationName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Applicant's or control affiliate's Position, Title, or Relationship
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:personDetail"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
				 	<blockquote>
						Was the Organization investment-related?
					</blockquote> 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:isInvestmentRelated = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:isInvestmentRelated = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No				
				</td>
			</tr>
			<tr>
				<td class="label">
					4. Court action brought in (Name of Federal, State or Foreign Court), 
					Location of Court (City or County <u>and</u> State or Country), 
					Docket/Case Number and Bankruptcy Chapter Number 
					(if Federal Bankruptcy Filing): 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
				 	<blockquote>
						Type of Court
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:typeOfCourt = 'Federal'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Federal&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:typeOfCourt = 'State'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;State&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:typeOfCourt = 'Foreign'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign									
				</td>
			</tr>
			<tr>
				<td class="label">
				 	<blockquote>
						Name of Federal, State or Foreign Court
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:nameOfCourt"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Location of Court
					</blockquote>
				</td>
				<td>
					&#160;
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City or County
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:cityOrCounty"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State or Country
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p3:stateOrCountry"/>
						</xsl:call-template>						
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Docket/Case Number
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:docketOrCaseNo"/>
					</div>
				</td>
			</tr>
			<xsl:if test="p3:typeOfCourt = 'Federal'">
				<tr>
					<td class="label">
						<blockquote>
							Bankruptcy Chapter Number (if Federal Bankruptcy Filing)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:bankruptcyChapterNo"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					5. Is action currently pending? 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:isActionPending = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:isActionPending= 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
			<xsl:if test="p3:isActionPending= 'N'">
				<tr>
					<td class="label">
						6. If not pending, provide Disposition Type: (check appropriate item) 
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p3:dispositionType , 'Direct')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Direct Payment Procedure<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:dispositionType , 'Satisfied')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dismissed Satisfied/Released	<br/>	
						<xsl:choose>
							<xsl:when test="contains(p3:dispositionType , 'Discharged')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Discharged<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:dispositionType , 'Dissolved')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dissolved	<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:dispositionType , 'SIPA')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;SIPA Trustee Appointed<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:dispositionType , 'Other')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Other
					</td>
				</tr>
				<xsl:if test="contains(p3:dispositionType , 'Other')">
					<tr>
						<td class="label">
							<blockquote>
								If Other, please specify
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:dispositionTypeOtherDesc"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						7. Disposition Date (MM/DD/YYYY): 
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:dispositionDate/p1:date"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
					 	<blockquote>
							Specify if Disposition Date is Exact or needs an Explanation
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:dispositionDate/p1:exactOrExplanation = 'Exact'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact
						<xsl:choose>
							<xsl:when test="p3:dispositionDate/p1:exactOrExplanation = 'Explanation'">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation	
					</td>
				</tr>
				<xsl:if test="p3:dispositionDate/p1:exactOrExplanation = 'Explanation'">
					<tr>
						<td class="label">
							<blockquote>
								If not exact, provide explanation:
							</blockquote> 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:dispositionDate/p1:explanationInfo"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					8. Provide a brief summary of events leading to the action and if not 
					discharged, explain. (The information must fit within the space provided.): 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:summaryOfEvents"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					9. If a SIPA trustee was appointed or a direct payment procedure was begun, 
					enter the amount paid or agreed to be paid by you; or the name of the trustee: 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Name of Trustee
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:nameOfTrustee"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Enter the amount paid or agreed to be paid by you
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select='format-number(p3:amountPaid , "$###,###,###,##0.00")' />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Currently open?
					</blockquote> 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:isCurrentlyOpen = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:isCurrentlyOpen = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
				 	<blockquote>
						Date Direct Payment Initiated/Filed or Trustee Appointed (MM/DD/YYYY):
					</blockquote> 
				</td>
				<td>	
					<div class="fakeBox2">
						<xsl:value-of select="p3:dateDirectPayment/p1:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Specify if Date Direct Payment Initiated/Filed or 
						Trustee Appointed is Exact or needs an Explanation
					</blockquote>
				</td>
				<td>	
					<xsl:choose>
						<xsl:when test="p3:dateDirectPayment/p1:exactOrExplanation = 'Exact'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Exact
					<xsl:choose>
						<xsl:when test="p3:dateDirectPayment/p1:exactOrExplanation = 'Explanation'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Explanation	
				</td>
			</tr>
			<xsl:if test="p3:dateDirectPayment/p1:exactOrExplanation = 'Explanation'">
				<tr>
					<td class="label">
						<blockquote>
							If not exact, provide explanation:
						</blockquote> 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:dateDirectPayment/p1:explanationInfo"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					10. Provide details of any status/disposition. 
					Include details of creditors, terms, conditions, 
					amounts due and settlement schedule (if applicable). 
					(The information must fit within the space provided.) 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:detailsOfDisposition"/>
					</div>
				</td>
			</tr>
		</table>		
	</xsl:template>
</xsl:stylesheet>