<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p3="http://www.sec.gov/edgar/sbse_drp">

	<xsl:template name="drp3_civilJudicial">
		<xsl:if test="count(p:civilJudicialDrpInfo/p3:civilJudicialDrp) &gt; 0">
			<h1>CIVIL JUDICIAL ACTION DISCLOSURE REPORTING PAGE (SBSE)</h1>
			<h4 class="title1"><em>GENERAL INSTRUCTIONS</em></h4>
			<div class="information">
				<p>
					You must provide a valid response to each question on every section of this DRP before 
					any of your information can be saved. Invalid or incomplete responses will prevent you 
					from closing the DRP with your information saved. It is recommended that you consult 
					the Print Form of this DRP to make sure you have gathered all the required information 
					before beginning your entry of information online.			
				</p>			
			</div>

			<xsl:call-template name="sbse_drp3_civilJudicial"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="sbse_drp3_civilJudicial">
		<xsl:for-each select="p:civilJudicialDrpInfo/p3:civilJudicialDrp">
			<xsl:call-template name="sbse_drp3_general"/>
			<xsl:call-template name="sbse_drp3_part1"/>
			
			<xsl:if test="contains(p3:drpFiledFor, 'Applicant')">
				<xsl:call-template name="sbse_drp3_applicantGeneral"/>
				<xsl:for-each select="p3:applicant/p3:civilJudicialDrpDetails">
					<xsl:call-template name="sbse_drp3_part2"/>
				</xsl:for-each>
			</xsl:if>
			
			<xsl:if test="contains(p3:drpFiledFor, 'affiliate')">
				<xsl:for-each select="p3:controlAffiliate">
					<xsl:call-template name="sbse_drp3_controlAffiliateGeneral"/>
					<xsl:if test="p3:controlAffiliateDetails/p3:isSubmittedToCRD ='N'">
						<xsl:for-each select="p3:civilJudicialDrpDetails">
							<xsl:call-template name="sbse_drp3_part2"/>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>	
	</xsl:template>
	<xsl:template name="sbse_drp3_general">
		<table role="presentation">
			<tr>
				<td class="label">
					This Disclosure Reporting Page [DRP (SBSE)] is an INITIAL <b><em>OR</em></b> AMENDED response to 
					report details for affirmative responses to <b><em>Items 14H</em></b> of Schedule D of Form SBSE;
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED
				</td>
			</tr>
			<tr>
				<td class="label">
					Check item(s) being responded to:
				</td>
				<td></td>
			</tr>
			<!-- VARIABLES BEGIN -->
			<xsl:variable name="drp3_itemAB_14H1A">
				<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
					<xsl:if test=". = '14H(1)(a)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>	
			
			<xsl:variable name="drp3_itemAB_14H1B">
				<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
					<xsl:if test=". = '14H(1)(b)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>	
			
			<xsl:variable name="drp3_itemAB_14H1C">
				<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
					<xsl:if test=". = '14H(1)(c)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>	
			
			<xsl:variable name="drp3_itemAB_14H2">
				<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
					<xsl:if test=". = '14H(2)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>			
			<!-- VARIABLES END -->
			<tr>
				<td class="label">
					<blockquote>
						14H (1) Has any domestic or foreign civil judicial court:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$drp3_itemAB_14H1A = '14H(1)(a)'">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(a) in the past ten years, enjoined the applicant or a control affiliate 
					in connection with any investment-related activity?<br/>
					<xsl:choose>
						<xsl:when test="$drp3_itemAB_14H1B = '14H(1)(b)'">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(b) ever found that the applicant or a control affiliate was involved 
					in a violation of investment-related statutes or regulations?<br/>
					<xsl:choose>
						<xsl:when test="$drp3_itemAB_14H1C = '14H(1)(c)'">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(c) ever dismissed, pursuant to a settlement agreement, 
					an investment-related civil judicial action brought 
					against the applicant or a control affiliate by a state or foreign financial regulatory authority?					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						14H (2)
					</blockquote> 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$drp3_itemAB_14H2 = '14H(2)'">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Is the applicant or a control affiliate now the subject of any civil judicial 
					proceeding that could result in a "yes" answer to any part of 14H(1)?
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Use a separate DRP for each event or <em>proceeding</em>. An event or proceeding may be reported for more than one 
				person or entity using one DRP. File with a completed Execution Page. One event may result in more than one affirmative 
				answer to Item 14H. Use only one DRP to report details related to the same event. Unrelated civil judicial actions must 
				be reported on separate DRPs.
				<br/><br/>
				It is not a requirement that documents be provided for each event or proceeding. Should they be provided, they will not 
				be accepted as disclosure in lieu of answering the questions on this DRP.
				<br/><br/>
				If a <em>control affiliate</em> is an individual or organization registered through the CRD, such <em>control affiliate</em> need only 
				complete Part I of the <em>applicant</em>'s appropriate DRP (SBSE). Details of the event must be submitted on the <em>control affiliate's</em> 
				appropriate DRP (BD) or DRP (U-4). If a <em>control affiliate</em> is an individual or organization <u>not</u> registered through the CRD, provide 
				complete answers to all the items on the <em>applicant</em>'s appropriate DRP (SBSE). The completion of this DRP does not 
				relieve the control affiliate of its obligation to update its CRD records.
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp3_part1">
		<h4 class="title1">PART I</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>person(s)</em> or entity(ies) for whom this DRP (SBSE) 
					is being filed is (are):
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'Applicant') and not(contains(p3:drpFiledFor, 'affiliate'))">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;The <em>Applicant</em><br/>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'and one or more')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;<em>Applicant</em> and one or more <em>control affiliate(s)</em><br/>					
					<xsl:choose>
						<xsl:when test="p3:drpFiledFor = 'One or more control affiliate(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;One or more <em>control affiliate(s)</em>				
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				If this DRP is being filed for a <em>control affiliate</em>, 
				give the full name of the <em>control affiliate</em> 
				below (for individuals, Last name, First name, Middle name).
				<br/>
				If the <em>control affiliate</em> is registered with the CRD, provide the CRD number. 
				If not, indicate "non-registered" by checking the appropriate checkbox.
			</p>
		</div>	
	</xsl:template>
	<xsl:template name="sbse_drp3_applicantGeneral">
		<h4 class="title2">SBSE - Applicant</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Name of <em>Applicant</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:applicant/p3:nameOfApplicant"/>
					</div>
				</td>
			</tr>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning the applicant from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:applicant/p3:isToRemove = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:applicant/p3:isToRemove = 'N'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No					
					</td>
				</tr>
				<xsl:if test="p3:applicant/p3:isToRemove = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'proceeding previously')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved in the applicant's favor.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'ten years ago')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.
						</td>
					</tr>	
					<xsl:if test="contains(p3:applicant/p3:drpRemovalReason, 'filed in error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:applicant/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>	
				</xsl:if>
			</xsl:if>			
		</table>		
	</xsl:template>
	<xsl:template name="sbse_drp3_controlAffiliateGeneral">
		<h4 class="title2">SBSE DRP - CONTROL AFFILIATE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					CRD NUMBER
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:crdNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					UIC NUMBER (if any)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:uicNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					This <em>Control Affiliate</em> is
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType='Firm'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType='Individual'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Individual
				</td>
			</tr>
			<tr>
				<td class="label">
					Is the <em>control affiliate</em> registered
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered='Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered='N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType='Firm'">
				<tr>
					<td class="label">
						NAME
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:nameOfFirm"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType='Individual'">
				<tr>
					<td class="label">
						Name of <em>Control Affiliate</em> Individual (CAI)
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Prefix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:prefix"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Last Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:lastName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							First Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:firstName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Middle Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:middleName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Suffix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:suffix"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning the 
						<em>control affiliate</em> from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'N'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No					
					</td>
				</tr>
				<xsl:if test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason, 'no longer')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The <em>control affiliate(s)</em> are no longer associated with the SBS Entity.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason, 'proceeding previously')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously 
									reported was resolved in the <em>control affiliate's</em> favor.  <br/>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason, 'ten years ago')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason, 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.	
						</td>
					</tr>	
					<xsl:if test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason, 'filed in error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:controlAffiliateDetails/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>	
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					B. If the <em>control affiliate</em> is registered through the CRD, has the <em>control affiliate</em> 
					submitted a DRP (with Form U-4) or DRP (BD) to the CRD System for the event?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD='Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD= 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		<div class="information">
			<p>
				If the answer is "Yes," no other information on this 
				DRP must be provided: If "No," complete Part II.
				<br/>
				<b>Note:</b> The completion of this Form does <u>not</u> 
				relieve the <em>control affiliate</em> of its obligation 
				to update its CRD records.			
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp3_part2">
		<h4 class="title2">PART II</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					1. Court Action initiated by:  (Name of regulator, foreign 
					financial regulatory authority, SRO, commodities exchange, 
					agency, firm, private plaintiff, etc.)
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Name of Person Who initiated the action
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:courtActionInitiatorName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Type of Person who initiated the action
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'Foreign Financial')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign Financial Regulatory Authority<br/>				
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'SRO')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;SRO<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'Commodities Exchange')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodities Exchange<br/>				
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'Agency')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Agency<br/>									
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'Firm')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'Private')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Private Plaintiff<br/>				
					<xsl:choose>
						<xsl:when test="p3:regulatoryAuthorityType = 'Regulatory Authority'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Regulatory Authority<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryAuthorityType , 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other
				</td>
			</tr>
			<xsl:if test="contains(p3:regulatoryAuthorityType , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>	
						<div class="fakeBox">
							<xsl:value-of select="p3:otherRegulatoryAuthority"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					2. Principal Relief Sought: (check appropriate item)
				</td>
				<td>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Cease and Desist')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Cease and Desist<br/>				
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Fine')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Civil Penalty(ies)/Fine(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Disgorgement')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Disgorgement<br/>				
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Injunction')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Injunction<br/>									
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Money')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Damages (Private/Civil Complaint)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Restitution')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restitution<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Restraining')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restraining Order<br/>											
					<xsl:choose>
						<xsl:when test="contains(p3:principalReliefSought , 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other				
				</td>
			</tr>
			<xsl:if test="contains(p3:principalReliefSought , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other selected, please describe
						</blockquote>
					</td>
					<td>	
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherPrincipleReliefSought"/>
						</div>
					</td>
				</tr>
			</xsl:if>	
			<!-- VARIABLES BEGINS-->
			<xsl:variable name="sbse_drp3_item2a">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Cease and Desist')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2b">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Fine')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2c">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Disgorgement')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2d">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Injunction')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2e">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Money')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2f">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Restitution')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2g">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Restraining')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item2h">
				<xsl:for-each select="p3:otherReliefSoughts/p3:otherReliefSought">
					<xsl:if test="contains(., 'Other')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES ENDS-->
			<tr>
				<td class="label">
					<blockquote>
						Other Relief Sought:
					</blockquote>
				</td>
				<td>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2a , 'Cease and Desist')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Cease and Desist<br/>				
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2b , 'Fine')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Civil Penalty(ies)/Fine(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2c , 'Disgorgement')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Disgorgement<br/>				
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2d , 'Injunction')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Injunction<br/>									
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2e , 'Money')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Damages (Private/Civil Complaint)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2f , 'Restitution')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restitution<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2g , 'Restraining')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restraining Order<br/>											
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item2h , 'Other')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other				
				</td>
			</tr>
			<xsl:if test="contains($sbse_drp3_item2h , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherOtherReliefSought"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					3.  Filing Date of Court Action  (MM/DD/YYYY)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:filingDateOfCourtAction/p1:date"/>
					</div>
				</td>
			</tr>
			<xsl:if test="count(p3:filingDateOfCourtAction/p1:date) &gt; 0">
				<tr>
					<td class="label">
						<blockquote>
							Specify if Filing Date of Court Action is Exact or needs an Explanation
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p3:filingDateOfCourtAction/p1:exactOrExplanation , 'Exact')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact											
						<xsl:choose>
							<xsl:when test="contains(p3:filingDateOfCourtAction/p1:exactOrExplanation , 'Explanation')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation	
					</td>
				</tr>
				<xsl:if test="contains(p3:filingDateOfCourtAction/p1:exactOrExplanation , 'Explanation')">
					<tr>
						<td class="label">
							<blockquote>
								If not exact, provide explanation:
							</blockquote>  
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:filingDateOfCourtAction/p1:explanationInfo"/>
							</div>
						</td>
					</tr>	
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					4. Principal Product Type: (check appropriate item)
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Fixed')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Fixed<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Variable')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Variable<br/>													
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Banking Products')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Banking Products (other than CD(s))<br/>		
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'CD(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;CD(s)<br/>		
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Commodity Option')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Option(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Asset Backed')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Asset Backed<br/>							
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Corporate')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Corporate<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Government')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Government<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Municipal')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Municipal<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Derivative')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Derivative(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'LP Interest(s)')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Direct Investment(s) - DPP &amp; LP Interest(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'OTC')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity - OTC<br/>							
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Equity Listed')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity Listed (Common &amp; Preferred Stock)<br/>						
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Commodity') and contains(p3:principalProductType , 'Futures')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Commodity<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Financial')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Financial<br/>								
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Index Option')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Index  Option(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Insurance')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Insurance<br/>							
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Investment Contract')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Investment Contract(s)<br/>								
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Money Market')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Market Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Mutual Fund')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Mutual Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'No Product')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No Product<br/>		
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Options'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Options<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Penny Stock')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Penny Stock(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Unit Investment')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Unit Investment Trust(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other				
				</td>
			</tr>
			<xsl:if test="contains(p3:principalProductType , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherPrincipalProductType"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<!-- VARIABLES BEGINS -->
			<xsl:variable name="sbse_drp3_item4_1">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Fixed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_2">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Variable')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_3">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Banking Products')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_4">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test=". = 'CD(s)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_5">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Commodity Option(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_6">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Asset Backed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_7">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Corporate')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_8">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Government')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_9">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Municipal')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_10">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Derivative(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_11">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'LP Interest(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_12">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Equity - OTC')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_13">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Equity Listed (Common')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_14">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Futures - Commodity')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_15">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Futures - Financial')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_16">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Index Option(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_17">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Insurance')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_18">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Investment Contract(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_19">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Money Market Fund(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_20">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Mutual Fund(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_21">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'No Product')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_22">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Options')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_23">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Penny Stock')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_24">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Unit Investment')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp3_item4_25">
				<xsl:for-each select="p3:otherProductTypes/p3:otherProductType">
					<xsl:if test="contains(. , 'Other')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES ENDS   -->
			<tr>
				<td class="label">
					<blockquote>
						Other Product Type:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_1 , 'Fixed')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Fixed<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_2 , 'Variable')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Variable<br/>													
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_3 , 'Banking Products')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Banking Products (other than CD(s))<br/>		
					<xsl:choose>
						<xsl:when test="$sbse_drp3_item4_4 = 'CD(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;CD(s)<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_5 , 'Commodity Option')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Option(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_6 , 'Asset Backed')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Asset Backed<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_7 , 'Corporate')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Corporate<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_8 , 'Government')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Government<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_9 , 'Municipal')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Municipal<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_10 , 'Derivative')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Derivative(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_11 , 'LP Interest(s)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Direct Investment(s) - DPP &amp; LP Interest(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_12 , 'OTC')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity - OTC<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_13 , 'Equity Listed')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity Listed (Common &amp; Preferred Stock)<br/>						
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_14 , 'Commodity')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Commodity<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_15 , 'Financial')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Financial<br/>								
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_16 , 'Index Option(s)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Index  Option(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_17 , 'Insurance')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Insurance<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_18 , 'Investment Contract')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Investment Contract(s)<br/>								
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_19 , 'Money Market')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Market Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_20 , 'Mutual Fund')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Mutual Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_21 , 'No Product')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No Product<br/>		
					<xsl:choose>
						<xsl:when test="$sbse_drp3_item4_22 = 'Options'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Options<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_23 , 'Penny Stock')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Penny Stock(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_24 , 'Unit Investment')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Unit Investment Trust(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp3_item4_25 , 'Other')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other	
				</td>
			</tr>
			<xsl:if test="contains($sbse_drp3_item4_25 , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherOtherProductType"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					5. Formal Action was brought in (include name of the Federal, State, 
					or Foreign Court; Location of Court – City or County <u>and</u> 
					State or Country, Docket/Case Number):
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:civilActionCourtType , 'Federal')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Federal Court&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p3:civilActionCourtType , 'State')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;State Court&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p3:civilActionCourtType , 'Foreign')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign Court
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Name of Federal, State, or Foreign Court
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:civilActionCourtName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Location of Court
					</blockquote>
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City or County
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:cityOrCounty"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>	
						<blockquote>				
							State or Country
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode"
								select="p3:stateOrCountry"/>
						</xsl:call-template>						
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Docket /Case Number
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:docketOrCaseNumber"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					6. Control Affiliate Employing Firm when activity occurred which led to the civil judicial action (if applicable): 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:cpEmployingFirm"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					7. Describe the allegations related to this civil judicial action. (The information must fit within the space provided.):
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:describeCivilActionAllegations"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					8. Current status?	
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:eventCurrentStatus , 'Pending')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Pending&#160;&#160;	
					<xsl:choose>
						<xsl:when test="contains(p3:eventCurrentStatus , 'Appeal')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;On Appeal&#160;&#160;	
					<xsl:choose>
						<xsl:when test="contains(p3:eventCurrentStatus , 'Final')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Final						
				</td>
			</tr>
			<xsl:if test="contains(p3:eventCurrentStatus , 'Appeal')">
				<tr>
					<td class="label">
						9. If on appeal, action appealed to (provide name of the court) and Date Appeal Filed (MM/DD/YYYY):
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Name of Court:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:courtName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Date Appeal Filed(MM/DD/YYYY):
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:dateAppealFiled"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="contains(p3:eventCurrentStatus , 'Pending')">
				<tr>
					<td class="label">
						10. If pending, date notice/process was served  (MM/DD/YYYY) 
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:processingDateCourtAction/p1:date"/>
						</div>
					</td>
				</tr>
				<xsl:if test="count(p3:processingDateCourtAction/p1:date) &gt; 0">
					<tr>
						<td class="label">
							<blockquote>
							Specify if notice/process date of Court Action  
							is Exact or needs an Explanation
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:processingDateCourtAction/p1:exactOrExplanation , 'Exact')">
									<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
								</xsl:when>											
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Exact
							<xsl:choose>
								<xsl:when test="contains(p3:processingDateCourtAction/p1:exactOrExplanation , 'Explanation')">
									<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
								</xsl:when>											
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Explanation						
						</td>
					</tr>
					<xsl:if test="contains(p3:processingDateCourtAction/p1:exactOrExplanation , 'Explanation')">
						<tr>
							<td class="label">
							 	<blockquote>
									If not exact, provide explanation:
								</blockquote>  
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:processingDateCourtAction/p1:explanationInfo"/>
								</div>
							</td>
						</tr>
					</xsl:if>				
				</xsl:if>
			</xsl:if>	
			<tr>
				<td class="label">
					<h4>If Final or On Appeal, complete all items below. 
					For Pending Actions, complete Item 14 only.</h4>
				</td>
				<td></td>
			</tr>
			<xsl:if test="not(contains(p3:eventCurrentStatus , 'Pending'))">
				<tr>
					<td class="label">
						11. How was matter resolved: (check appropriate item)
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Consent')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Consent	<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Dismissed')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dismissed	<br/>		
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Judgement')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Judgement Rendered	<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Opinion')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Opinion	<br/>	
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Settled')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Settled	<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Withdrawn')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Withdrawn	<br/>	
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolveType , 'Other')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Other
					</td>
				</tr>	
				<xsl:if test="contains(p3:matterResolveType , 'Other')">
					<tr>
						<td class="label">
							<blockquote>
								If you selected "Other", please specify
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:otherMatterResolveType"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						12.  Resolution Date (MM/DD/YYYY)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:resolutionDate/p1:date"/>
						</div>
					</td>
				</tr>
				<xsl:if test="count(p3:resolutionDate/p1:date) &gt; 0">
					<tr>
						<td class="label">
						 	<blockquote>
								Specify if Resolution Date is Exact or needs an Explanation
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:resolutionDate/p1:exactOrExplanation , 'Exact')">
									<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
								</xsl:when>											
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Exact	
							<xsl:choose>
								<xsl:when test="contains(p3:resolutionDate/p1:exactOrExplanation , 'Explanation')">
									<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
								</xsl:when>											
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Explanation					
						</td>
					</tr>
					<xsl:if test="contains(p3:resolutionDate/p1:exactOrExplanation , 'Explanation')">
						<tr>
							<td class="label">
								<blockquote>
									If not exact, provide explanation:
								</blockquote> 
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:resolutionDate/p1:explanationInfo"/>
								</div>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
				<!-- VARIABLES BEGINS -->
				<xsl:variable name="sbse_drp3_item13a">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Monetary')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_drp3_item13b">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Revocation')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_drp3_item13c">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Censure')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_drp3_item13d">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Cease')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_drp3_item13e">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Disgorgement')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse_drp3_item13f">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Bar')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable><xsl:variable name="sbse_drp3_item13g">
					<xsl:for-each select="p3:sanctionReliefTypes/p3:sanctionReliefType">
						<xsl:if test="contains(., 'Suspension')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						13.  Resolution Detail
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						A. Were any of the following Sanctions Ordered 
						or Relief Granted? (Check all appropriate items):
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp3_item13a , 'Monetary')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Monetary/Fine	<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse_drp3_item13b , 'Revocation')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Revocation/Expulsion/Denial	<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp3_item13c , 'Censure')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Censure	<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse_drp3_item13d , 'Cease')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Cease and Desist/Injunction	<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse_drp3_item13e , 'Disgorgement')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Disgorgement/Restitution	<br/>	
						<xsl:choose>
							<xsl:when test="$sbse_drp3_item13f = 'Bar'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Bar	<br/>
						<xsl:choose>
							<xsl:when test="$sbse_drp3_item13g = 'Suspension'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Suspension				
					</td>
				</tr>	
				<xsl:if test="contains($sbse_drp3_item13a , 'Monetary')">
					<tr>
						<td class="label">
							<blockquote>
							<blockquote>
							Amount
							</blockquote>
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select='format-number(p3:grantOrFineAmount , "$###,###,###,##0.00")' />
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						<blockquote>
						B. Other Sanctions:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherSanctionsOrdered"/>
						</div>
					</td>
				</tr>				
				<tr>
					<td class="label">
						<blockquote>
						C. Sanction Detail:  If suspended, enjoined or barred, provide duration including start date and 
						capacities affected (General Securities Principal, Financial Operations Principal, etc.).  
						If requalification, by exam/retraining was a condition of the sanction, provide length of time 
						given to re-qualify/retrain, type of exam required and whether condition has been satisfied.  
						If disposition resulted in a fine, penalty, restitution, disgorgement or monetary compensation, 
						provide total amount, portion levied against principal, date paid and if any portion of penalty was waived.
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:sanctionDetail"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					14.  Provide a brief summary of details related to action(s), allegation(s), disposition(s) and/or 
					finding(s) disclosed above. (The information must fit within the space provided.)
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:summaryOfCircumstances"/>
					</div>
				</td>
			</tr>
		</table>	
	</xsl:template>
</xsl:stylesheet>