<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p3="http://www.sec.gov/edgar/sbse_drp">

	<xsl:template name="drp2_regulatoryAction">
		<xsl:if test="count(p:regulatoryDrpInfo/p3:regulatoryDrp) &gt; 0">
			<h1>REGULATORY ACTION DISCLOSURE REPORTING PAGE (SBSE)</h1>
			<h4 class="title1"><em>GENERAL INSTRUCTIONS</em></h4>
			<div class="information">
				<p>
					You must provide a valid response to each question on every section of this DRP before 
					any of your information can be saved. Invalid or incomplete responses will prevent you 
					from closing the DRP with your information saved. It is recommended that you consult 
					the Print Form of this DRP to make sure you have gathered all the required information 
					before beginning your entry of information online.			
				</p>			
			</div>
		
			<xsl:call-template name="sbse_drp2_regulatoryAction"/>
		</xsl:if>	
	</xsl:template>

	<!-- Child templates for SBSE -->
	<xsl:template name="sbse_drp2_regulatoryAction">
		<xsl:for-each select="p:regulatoryDrpInfo/p3:regulatoryDrp">
			<xsl:call-template name="sbse_drp2_general"/>
			<xsl:call-template name="sbse_drp2_part1"/>
			
			<xsl:if test="contains(p3:drpFiledFor, 'Applicant')">
				<xsl:call-template name="sbse_drp2_applicantGeneral"/>
				<xsl:for-each select="p3:applicant/p3:regulatoryDrpDetails">
					<xsl:call-template name="sbse_drp2_part2"/>
				</xsl:for-each>
			</xsl:if>
			
				<xsl:if test="contains(p3:drpFiledFor, 'affiliate')">
				<xsl:for-each select="p3:controlAffiliate">
					<xsl:call-template name="sbse_drp2_controlAffiliateGeneral"/>
					<xsl:if test="p3:controlAffiliateDetails/p3:isSubmittedToCRD ='N'">
						<xsl:for-each select="p3:regulatoryDrpDetails">
							<xsl:call-template name="sbse_drp2_part2"/>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="sbse_drp2_general">
		<!-- VARIABLES BEGIN -->
		<xsl:variable name="sbse_drp2_itemAB_14C1">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14C(1)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14C2">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14C(2)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14C3">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14C(3)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14C4">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14C(4)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14C5">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14C(5)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14D1">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14D(1)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14D2">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14D(2)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14D3">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14D(3)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14D4">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14D(4)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14D5">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14D(5)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14E1">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14E(1)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14E2">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14E(2)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14E3">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14E(3)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14E4">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14E(4)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14F">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14F'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp2_itemAB_14G">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test=". = '14G'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<!-- VARIABLES END -->
		<table role="presentation">
			<tr>
				<td class="label">
					This Disclosure Reporting Page [(DRP SBSE)] is an INITIAL <b><em>OR</em></b> AMENDED 
					response to report details for affirmative responses to <b><em>Items  14C, 
					14D, 14E, 14F, or 14G</em></b> of Form SBSE;
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED
				</td>
			</tr>
			<tr>
				<td class="label">
					Check item(s) being responded to: 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					14C. Has the U.S. Securities and Exchange Commission 
					or the Commodity Futures Trading Commission ever:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14C1 , '14C(1)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) Found the principal to have made a false statement or omission?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14C2 , '14C(2)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) Found the principal to have been involved in a violation of its regulations or statutes?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14C3 , '14C(3)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(3) the principal to have been a cause of an investment-related business having 
					its authorization to do business denied, revoked, or restricted?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14C4 , '14C(4)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(4) Entered an order against the principal 
					in connection with investment-related activity?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14C5 , '14C(5)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(5) Imposed a civil money penalty on the principal, 
					or ordered the principal to cease and desist from any activity?					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					14D. Has any other federal regulatory agency, state regulatory agency, 
					or foreign financial regulatory authority:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14D1 , '14D(1)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) Ever found the principal to have made a false statement 
					or omission or been dishonest, unfair, or unethical?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14D2 , '14D(2)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) Ever found the principal to have been involved in 
					a violation of investment-related regulations or statutes?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14D3 , '14D(3)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(3) Ever found the principal to have been a cause of 
					an investment-related business having its authorization to do business 
					denied, suspended, revoked or
					restricted?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14D4 , '14D(4)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(4) In the past ten years, entered an order against 
					the principal in connection with an investment-related activity?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14D5 , '14D(5)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(5) Ever denied, suspended, or revoked the principal's 
					registration or license or otherwise, by order, prevented it from associating 
					with an investment-related business or restricted its activities?				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					14E. Has any self-regulatory organization or commodities exchange ever:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14E1 , '14E(1)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) found the principal to have made a false statement or omission?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14E2 , '14E(2)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) found the principal to have been involved in a violation of its rules 
					(other than a violation designated as a "minor rule violation" under a plan approved by the
					U.S. Securities and exchange Commission)?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14E3 , '14E(3)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(3) found the principal to have been the cause of an investment-related business having 
					its authorization to do business denied, suspended, revoked or restricted?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14E4 , '14E(4)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(4) Disciplined the principal by expelling or suspending it 
					from membership, barring or suspending its association with other members, or 
					otherwise restricting its activities?				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					14F.
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14F , '14F')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Has the applicant's or a control affiliate's authorization to act as an 
					attorney, accountant, or federal contractor ever been revoked or suspended?
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					14G.
					</blockquote>				
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_itemAB_14G , '14G')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Is the applicant or a control affiliate now the subject of any regulatory 
					proceeding that could result in a "yes" answer to any part of 14C, D, or E?
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Use a separate DRP for each event or <em>proceeding</em>. An event or proceeding may be reported for more than one person 
				or entity using one DRP. File with a completed Execution Page.
				<br/><br/>
				One event may result in more than one affirmative answer to Items 14C, 14D, 14E, 14F or 14G. Use only one DRP to report 
				details related to the same event. If an event gives rise to actions by more than one regulator, provide details for each 
				action on a separate DRP.
				<br/><br/>			
				It is not a requirement that documents be provided for each event or proceeding. Should they be provided, they will not be 
				accepted as disclosure in lieu of answering the questions on this DRP.
				<br/><br/>
				If a <em>control affiliate</em> is an individual or organization registered through the CRD, such <em>control affiliate</em> 
				need only complete Part I of the <em>applicant</em>'s appropriate DRP (SBSE). Details of the event must be submitted on the 
				<em>control affiliate</em>'s appropriate DRP (BD) or DRP (U-4). If a <em>control affiliate</em> is an individual or organization 
				not registered through the CRD, provide complete answers to all the items on the <em>applicant</em>'s appropriate DRP (SBSE). 
				The completion of this DRP does not relieve the <em>control affiliate</em> of its obligation to update its CRD records.
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp2_part1">
		<h4 class="title1">PART I</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>person(s)</em> or entity(ies) for whom this DRP (SBSE) is being filed is (are):
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'Applicant') and not(contains(p3:drpFiledFor, 'one or more')) ">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;The <em>Applicant</em><br/>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'and one or more')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;<em>Applicant</em> and one or more <em>control affiliate(s)</em><br/>					
					<xsl:choose>
						<xsl:when test="p3:drpFiledFor = 'One or more control affiliate(s)'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;One or more <em>control affiliate(s)</em>
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				If this DRP is being filed for a <em>control affiliate</em>, give the full name of 
				the <em>control affiliate</em> below (for individuals, Last name, First name, Middle name).
				<br/>
				If the <em>control affiliate</em> is registered with the CRD, provide the CRD number. 
				If not, indicate "non-registered" by checking the appropriate checkbox.
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp2_applicantGeneral">
		<h4 class="title2">Applicant</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Name of <em>Applicant</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:applicant/p3:nameOfApplicant"/>
					</div>
				</td>
			</tr>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning the applicant from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:applicant/p3:isToRemove = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:applicant/p3:isToRemove = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No					
					</td>
				</tr>
				<xsl:if test="p3:applicant/p3:isToRemove = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'proceeding previously')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved in the applicant's favor.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'ten years ago')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.	
						</td>
					</tr>	
					<xsl:if test="contains(p3:applicant/p3:drpRemovalReason, 'filed in error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:applicant/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>		
				</xsl:if>
			</xsl:if>
		</table>		
	</xsl:template>	
		<xsl:template name="sbse_drp2_controlAffiliateGeneral">
		<h4 class="title2">SBSE DRP - CONTROL AFFILIATE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					CRD NUMBER
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:crdNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					UIC NUMBER (if any)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:uicNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					This <em>Control Affiliate</em> is
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType='Firm'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType='Individual'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Individual
				</td>
			</tr>
			<tr>
				<td class="label">
					Is the <em>control affiliate</em> registered
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered='Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered='N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType='Firm'">
				<tr>
					<td class="label">
						NAME
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:nameOfFirm"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType='Individual'">
				<tr>
					<td class="label">
						Name of <em>Control Affiliate</em> Individual (CAI)
					</td>
					<td>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Prefix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:prefix"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Last Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:lastName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						First Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:firstName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Middle Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:middleName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						Suffix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:suffix"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP 
						concerning the <em>control affiliate</em> from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved='Y'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved= 'N'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No
					</td>
				</tr>
				<xsl:if test="p3:controlAffiliateDetails/p3:isShouldBeRemoved='Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'no longer associated')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The <em>control affiliate(s)</em> are no longer associated with the SBS Entity.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'proceeding previously')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved 
							in the <em>control affiliate's</em> favor<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'ten years ago')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason, 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.	
						</td>
					</tr>	
					<xsl:if test="contains(p3:applicant/p3:drpRemovalReason, 'filed in error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:applicant/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>		
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					B. If the <em>control affiliate</em>(s) is registered through the CRD, has the 
					<em>control affiliate</em>(s)
					submitted a DRP (with Form U-4) or DRP (BD) to the CRD System for the event?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD= 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD= 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		
		<div class="information">
			<p>
				If the answer is "Yes," no other information on this DRP must be provided: If "No," complete Part II.
				<br/>
				<b>Note:</b> The completion of this Form does <u>not</u> relieve the control affiliate of its obligation to update its CRD records.				
			</p>
		</div>
	</xsl:template>			
	<xsl:template name="sbse_drp2_part2">
		<h4 class="title2">PART II</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					1. Regulatory Action initiated by:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryActionInitiatedBy, 'SEC')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;SEC&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryActionInitiatedBy, 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other Federal&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryActionInitiatedBy, 'State')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;State&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryActionInitiatedBy, 'SRO')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;SRO&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p3:regulatoryActionInitiatedBy, 'Foreign')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign														
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(Full name of regulator, foreign financial 
						regulatory authority, federal, state or SRO)
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:regulatorName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					2.  Principal Sanction: (check appropriate item)
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Civil')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Civil and Administrative Penalty(ies)/Fine(s)<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Bar')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Bar<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Cease')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Cease and Desist<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Censure')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Censure	<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Denial')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Denial		<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Disgorgement')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Disgorgement<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Expulsion')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Expulsion<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Injunction')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Injunction<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Prohibition')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Prohibition	<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Reprimand')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Reprimand		<br/>	
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Restitution')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restitution<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Revocation')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Revocation<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Suspension')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Suspension<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Undertaking')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Undertaking	<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalSanction, 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other												
				</td>
			</tr>
			<xsl:if test="contains(p3:principalSanction, 'Other')">
				<tr>
					<td class="label">
						<blockquote>
						If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:otherPrincipalSanctionDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<!-- VARIABLES BEGIN -->
			<xsl:variable name="sbse_drp2_item2a">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Penalty')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2b">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Bar'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2c">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Cease and Desist'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2d">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Censure'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2e">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Denial'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2f">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Disgorgement'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2g">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Expulsion'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2h">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Injunction'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2i">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Prohibition'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2j">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Reprimand'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2k">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Restitution'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2l">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Revocation'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2m">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Suspension'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2n">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Undertaking'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item2o">
				<xsl:for-each select="p3:otherPrincipalSanction">
					<xsl:if test=". = 'Other'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES END -->
			<tr>
				<td class="label">
					<blockquote>
						Other Sanctions:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2a , 'Civil')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Civil and Administrative Penalty(ies)/Fine(s)<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2b , 'Bar')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Bar<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2c , 'Cease')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Cease and Desist<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2d , 'Censure')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Censure	<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2e , 'Denial')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Denial		<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2f , 'Disgorgement')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Disgorgement<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2g , 'Expulsion')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Expulsion<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2h , 'Injunction')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Injunction<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2i , 'Prohibition')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Prohibition	<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2j , 'Reprimand')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Reprimand		<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2k , 'Restitution')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restitution<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2l , 'Revocation')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Revocation<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2m , 'Suspension')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Suspension<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2n , 'Undertaking')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Undertaking	<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item2o , 'Other')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other	
				</td>
			</tr>
			<xsl:if test="contains($sbse_drp2_item2o, 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:otherSanctionsDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					3.  Date Initiated (MM/DD/YYYY)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:dateInitiated/p1:date"/>
					</div>
				</td>
			</tr>
			<xsl:if test="count(p3:dateInitiated/p1:date) &gt; 0">
				<tr>
					<td class="label">
						<blockquote>
							Specify if Date Initiated is Exact or needs an Explanation
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:dateInitiated/p1:exactOrExplanation = 'Exact'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact
						<xsl:choose>
							<xsl:when test="p3:dateInitiated/p1:exactOrExplanation = 'Explanation'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation				
					</td>
				</tr>
				<xsl:if test="p3:dateInitiated/p1:exactOrExplanation = 'Explanation'">
					<tr>
						<td class="label">
							<blockquote>
								If not exact, provide explanation:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:dateInitiated/p1:explanationInfo"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					4.Docket/Case Number:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:docketOrCaseNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					5. Control Affiliate Employing Firm when activity occurred which led to the regulatory action (if applicable):
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:controlAffiliateEmployingFirm"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					6. Principal Product Type: (check appropriate item)
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Annuity(ies) - Fixed'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Fixed<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Annuity(ies) - Variable'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Variable <br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Banking Products (other than CD(s))'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Banking Products (other than CD(s)) <br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'CD(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;CD(s)<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Commodity Option(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Option(s)<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Debt - Asset Backed'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Asset Backed <br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Debt - Corporate'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Corporate<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Debt - Government'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Government<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Debt - Municipal'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Municipal<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Derivative(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Derivative(s)<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'LP Interest(s)')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Direct Investment(s) - DPP &amp; LP Interest(s)<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Equity - OTC'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity - OTC<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Preferred Stock')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity Listed (Common &amp; Preferred Stock)<br/>
					<xsl:choose>
						<xsl:when test="contains(p3:principalProductType , 'Commodity') and contains(p3:principalProductType , 'Future')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Commodity<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Futures - Financial'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Financial<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Index Option(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Index Option(s)<br/>	
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Insurance'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Insurance<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Investment Contract(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Investment Contract(s)<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Money Market Fund(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Market Fund(s)		<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Mutual Fund(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Mutual Fund(s)	<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'No Product'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No Product<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Options'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Options<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Penny Stock(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Penny Stock(s)<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Unit Investment Trust(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Unit Investment Trust(s)	<br/>
					<xsl:choose>
						<xsl:when test="p3:principalProductType = 'Other'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other																																								
				</td>
			</tr>
			<xsl:if test="p3:principalProductType = 'Other'">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:principalProductTypeOtherDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<!-- VARIABLES BEGIN -->
			<xsl:variable name="sbse_drp2_item6_1">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Fixed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_2">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Variable')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_3">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Banking Products')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_4">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test=". = 'CD(s)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_5">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Commodity Option(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_6">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Asset Backed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_7">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Corporate')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_8">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Government')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_9">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Municipal')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_10">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Derivative(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_11">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Direct Investment(s)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_12">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'OTC')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_13">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Equity Listed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_14">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Futures - Commodity')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_15">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Futures - Financial')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_16">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Index')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_17">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Insurance')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_18">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Investment Contract')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_19">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Money Market Fund')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_20">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Mutual Fund')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_21">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'No Product')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_22">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Options')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_23">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Penny Stock')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_24">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Unit Investment Trust')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse_drp2_item6_25">
				<xsl:for-each select="p3:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Other')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES END -->
			<tr>
				<td class="label">
					<blockquote>
						Other Product Type:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_1 = 'Annuity(ies) - Fixed'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Fixed<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_2 = 'Annuity(ies) - Variable'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Variable <br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_3 = 'Banking Products (other than CD(s))'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Banking Products (other than CD(s)) <br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_4 = 'CD(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;CD(s)<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_5 = 'Commodity Option(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Option(s)<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_6 = 'Debt - Asset Backed'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Asset Backed <br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_7 = 'Debt - Corporate'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Corporate<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item6_8 ,'Government')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Government<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item6_9 ,'Municipal')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Municipal<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_10 = 'Derivative(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Derivative(s)<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item6_11, 'LP Interest(s)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Direct Investment(s) - DPP &amp; LP Interest(s)<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_12 = 'Equity - OTC'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity - OTC<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item6_13 , 'Preferred Stock')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity Listed (Common &amp; Preferred Stock)<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse_drp2_item6_14 , 'Commodity')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Commodity<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_15 = 'Futures - Financial'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Financial<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_16 = 'Index Option(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Index Option(s)<br/>	
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_17 = 'Insurance'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Insurance<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_18 = 'Investment Contract(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Investment Contract(s)<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_19 = 'Money Market Fund(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Market Fund(s)		<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_20 = 'Mutual Fund(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Mutual Fund(s)	<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_21 = 'No Product'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No Product<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_22 = 'Options'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Options<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_23 = 'Penny Stock(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Penny Stock(s)<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_24 = 'Unit Investment Trust(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Unit Investment Trust(s)	<br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp2_item6_25 = 'Other'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other				
				</td>
			</tr>
			<xsl:if test="$sbse_drp2_item6_25 = 'Other'">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherProductDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					7. Describe the allegations related to this regulatory action. (The information must fit within the space provided.):
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:descAllegations"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					8. Current Status ?				
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:currentStatus = 'Pending'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Pending&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:currentStatus = 'On Appeal'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;On Appeal&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:currentStatus = 'Final'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Final						
				</td>
			</tr>
			<xsl:if test="p3:currentStatus = 'On Appeal'">
				<tr>
					<td class="label">
						9. If on appeal, regulatory action appealed to: 
						(SEC, SRO, Federal or State Court):
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:appealedTo = 'SEC'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;SEC&#160;&#160;
						<xsl:choose>
							<xsl:when test="p3:appealedTo = 'SRO'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;SRO&#160;&#160;
						<xsl:choose>
							<xsl:when test="p3:appealedTo = 'Federal Court'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Federal Court&#160;&#160;
						<xsl:choose>
							<xsl:when test="p3:appealedTo = 'State Court'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;State Court&#160;&#160;				
						<xsl:choose>
							<xsl:when test="p3:appealedTo = 'Other'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Other				
					</td>
				</tr>
				<xsl:if test="p3:appealedTo = 'Other'">
					<tr>
						<td class="label">
							<blockquote>
								If Other is selected, please describe
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:otherDescribe"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						9. and Date Appeal Filed:
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:dateAppealFiled"/>
						</div>
					</td>
				</tr>				
			</xsl:if>
			<xsl:if test="not(p3:currentStatus = 'Pending')">
				<tr>
					<td class="label">
						<h4>If Final or On Appeal, complete all items below. 
						For Pending Actions, complete Item 13 only.</h4>
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						10. How was matter resolved: (check appropriate item)
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolvedType, 'Acceptance')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Acceptance, Waiver &amp; Consent (AWC)<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolvedType, 'Order of Offer of Settlement')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Decision &amp; Order of Offer of Settlement<br/>
						<xsl:choose>
							<xsl:when test="p3:matterResolvedType = 'Decision'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Decision<br/>		
						<xsl:choose>
							<xsl:when test="p3:matterResolvedType = 'Consent'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Consent<br/>
						<xsl:choose>
							<xsl:when test="p3:matterResolvedType = 'Dismissed'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dismissed<br/>
						<xsl:choose>
							<xsl:when test="p3:matterResolvedType = 'Order'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Order<br/>							
						<xsl:choose>
							<xsl:when test="p3:matterResolvedType = 'Settled'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Settled<br/>
						<xsl:choose>
							<xsl:when test="contains(p3:matterResolvedType, 'Stipulation')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Stipulation and Consent<br/>
						<xsl:choose>
							<xsl:when test="p3:matterResolvedType = 'Vacated'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Vacated							
					</td>
				</tr>
				<tr>
					<td class="label">
						11. Resolution Date (MM/DD/YYYY)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:resolutionDate/p1:date"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							Specify if Resolution Date is Exact or needs an Explanation:
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p3:resolutionDate/p1:exactOrExplanation, 'Exact')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact
						<xsl:choose>
							<xsl:when test="contains(p3:resolutionDate/p1:exactOrExplanation, 'Explanation')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation				
					</td>
				</tr>
				<xsl:if test="contains(p3:resolutionDate/p1:exactOrExplanation, 'Explanation')">
					<tr>
						<td class="label">
							<blockquote>
								If not exact, provide explanation:
							</blockquote>  
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p3:resolutionDate/p1:explanationInfo"/>
							</div>
						</td>
					</tr>				
				</xsl:if>
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse_drp2_item12a">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Monetary')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<xsl:variable name="sbse_drp2_item12b">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Revocation')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<xsl:variable name="sbse_drp2_item12c">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Censure')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<xsl:variable name="sbse_drp2_item12d">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Cease')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<xsl:variable name="sbse_drp2_item12e">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Disgorgement')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<xsl:variable name="sbse_drp2_item12f">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Bar')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<xsl:variable name="sbse_drp2_item12g">
					<xsl:for-each select="p3:sanctionsOrdered/p3:sanctionOrdered">
						<xsl:if test="contains(., 'Suspension')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>				
				</xsl:variable>
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						12. A. Were any of the following Sanctions 
						Ordered? (Check all appropriate items):
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12a , 'Monetary')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Monetary/Fine<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12b , 'Revocation')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Revocation/Expulsion/Denial<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12c , 'Censure')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Censure<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12d , 'Cease')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Cease and Desist/Injunction	<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12e , 'Disgorgement')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Disgorgement/Restitution<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12f , 'Bar')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Bar<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse_drp2_item12g , 'Suspension')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Suspension													
					</td>
				</tr>	
				<xsl:if test="contains($sbse_drp2_item12a , 'Monetary')">			
					<tr>
						<td class="label">
							<blockquote>
							<blockquote>
								Amount:
							</blockquote>
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select='format-number(p3:monetaryFineAmount , "$###,###,###,##0.00")' />						
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						<blockquote>
							B. Other Sanctions Ordered:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:otherSanctionsOrdered"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							C. Sanction Detail:  If suspended, enjoined or barred, provide duration including start date and capacities affected (General Securities Principal, 
							Financial Operations Principal, etc.).  If requalification, by exam/retraining was a condition of the sanction, provide length of time given to 
							re-qualify/retrain, type of exam required and whether condition has been satisfied.  If disposition resulted in a fine, penalty, restitution, 
							disgorgement or monetary compensation, provide total amount, portion levied against principal, date paid and if any portion of penalty was waived.
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:sanctionDetail"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					13. Provide a brief summary of details related to the action status and (or) disposition and include relevant terms, 
					conditions and dates. (The information must fit within the space provided.)
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:summaryOfDetails"/>
					</div>
				</td>
			</tr>
		</table>	
	</xsl:template>
</xsl:stylesheet>