<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsefiler"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p3="http://www.sec.gov/edgar/sbse_drp">

	<xsl:template name="drp1_criminal">
		<xsl:if test="count(p:criminalDrpInfo/p3:criminalDrp) &gt; 0">
			<h1>CRIMINAL DISCLOSURE REPORTING PAGE (SBSE)</h1>
			<h4 class="title1"><em>GENERAL INSTRUCTIONS</em></h4>
			<div class="information">
				<p>
					You must provide a valid response to each question on every section of this DRP before 
					any of your information can be saved. Invalid or incomplete responses will prevent you 
					from closing the DRP with your information saved. It is recommended that you consult 
					the Print Form of this DRP to make sure you have gathered all the required information 
					before beginning your entry of information online.			
				</p>		
			</div>

			<xsl:for-each select="p:criminalDrpInfo/p3:criminalDrp">
				<xsl:call-template name="sbse_drp1_general"/>
				<xsl:call-template name="sbse_drp1_part1"/>
				
				<xsl:if test="contains(p3:drpFiledFor, 'Applicant')">
					<xsl:call-template name="sbse_drp1_applicantGeneral"/>
					<xsl:for-each select="p3:applicant">
						<xsl:call-template name="sbse_drp1_part2"/>
					</xsl:for-each>						
				</xsl:if>
				<xsl:if test="contains(p3:drpFiledFor, 'affiliate')">
					<xsl:for-each select="p3:controlAffiliate">
						<xsl:call-template name="sbse_drp1_controlAffiliateGeneral"/>
							<xsl:if test="p3:controlAffiliateDetails/p3:isSubmittedToCRD = 'N'">
								<xsl:call-template name="sbse_drp1_part2"/>
							</xsl:if>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template name="sbse_drp1_controlAffiliateGeneral">
		<h4 class="title2">SBSE DRP - CONTROL AFFILIATE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					CRD NUMBER
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:crdNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					UIC NUMBER (if any)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:controlAffiliateDetails/p3:uicNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					This <em>Control Affiliate</em> is
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType = 'Firm'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:personType = 'Individual'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Individual				
				</td>
			</tr>
			<tr>
				<td class="label">
					Is the <em>control affiliate</em> registered
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isPersonRegistered = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType = 'Firm'">
				<tr>
					<td class="label">
						NAME
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:nameOfFirm"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p3:controlAffiliateDetails/p3:personType = 'Individual'">
				<tr>
					<td class="label">
						Name of <em>Control Affiliate</em> Individual (CAI)
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Prefix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:prefix"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Last Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:lastName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							First Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:firstName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Middle Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:middleName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Suffix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p3:controlAffiliateDetails/p3:suffix"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="contains($submissionType, '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning 
						the <em>control affiliate</em> from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No
					</td>
				</tr>
				<xsl:if test="p3:controlAffiliateDetails/p3:isShouldBeRemoved = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason , 'no longer associated with the SBS Entity')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The <em>control affiliate(s)</em> are no longer associated with the SBS Entity.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason , 'previously reported')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved in the control affiliate's favor. <br/>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason , 'ten years ago')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason , 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error. 
						</td>
					</tr>
					<xsl:if test="contains(p3:controlAffiliateDetails/p3:drpRemovalReason , 'filed in error')">
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:controlAffiliateDetails/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					B. If the <em>control affiliate</em>(s) is registered through the CRD, has the 
					<em>control affiliate</em>(s)
					submitted a DRP (with Form U-4) or DRP (BD) to the CRD System for the event?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:controlAffiliateDetails/p3:isSubmittedToCRD = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		
		<div class="information">
			<p>
				If the answer is "Yes," no other information on this DRP must be provided: If "No," complete Part II.
				<br/>
				<b>Note:</b> The completion of this Form does <u>not</u> relieve the <em>control affiliate</em> of its obligation to update its CRD records.			
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp1_applicantGeneral">
		<h4 class="title2">Applicant</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Name of <em>Applicant</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:applicant/p3:nameOfApplicant"/>
					</div>
				</td>
			</tr>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						Is this DRP an amendment that seeks to remove a previously filed DRP concerning the applicant from the record?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p3:applicant/p3:isToRemove = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p3:applicant/p3:isToRemove = 'N'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No					
					</td>
				</tr>
				<xsl:if test="p3:applicant/p3:isToRemove = 'Y'">
					<tr>
						<td class="label">
							If "Yes," the reason the DRP should be removed is:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'proceeding previously')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding previously reported was resolved in the applicant's favor.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'proceeding occurred')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p3:applicant/p3:drpRemovalReason , 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error.	
						</td>
					</tr>	
					<xsl:if test="contains(p3:applicant/p3:drpRemovalReason , 'filed in error')">		
						<tr>
							<td class="label">
								<blockquote>
									Explain the circumstances:
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p3:applicant/p3:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
		</table>		
	</xsl:template>
	<xsl:template name="sbse_drp1_general">
		<!-- VARIABLES BEGIN -->
		<xsl:variable name="sbse_drp1_itemAB_14A1">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test="contains(. , '14A(1)')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp1_itemAB_14A2">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test="contains(. , '14A(2)')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp1_itemAB_14B1">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test="contains(. , '14B(1)')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse_drp1_itemAB_14B2">
			<xsl:for-each select="p3:respondingTo/p3:responseQuestion">
				<xsl:if test="contains(. , '14B(2)')">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<!-- VARIABLES END -->
		<table role="presentation">
			<tr>
				<td class="label">
					This Disclosure Reporting Page [DRP (SBSE)] is an INITIAL OR  AMENDED response to report 
					details for affirmative responses to <b><em>Items 14A and 14B</em></b> of Form SBSE;
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p3:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED				
				</td>
			</tr>
			<tr>
				<td class="label">
					Check item(s) being responded to: 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						14A. In the past ten years has the applicant or a control affiliate:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse_drp1_itemAB_14A1 = '14A(1)'">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) Been convicted of or pled guilty or nolo contendere 
					("no contest") in a domestic, foreign or military court to any felony? <br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp1_itemAB_14A2 = '14A(2)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) Been charged with a felony?									
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						14B. In the past ten years has the applicant or a control affiliate:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse_drp1_itemAB_14B1 = '14B(1)'">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) Been convicted of or pled guilty or or nolo contendere ("no contest") in a domestic, 
					foreign or military court to a misdemeanor involving: financial services industry-related business, or any fraud, 
					false statements or omissions, wrongful taking of property, bribery, perjury, forgery, counterfeiting, extortion, 
					or a conspiracy to commit any of these offenses? <br/>
					<xsl:choose>
						<xsl:when test="$sbse_drp1_itemAB_14B2 = '14B(2)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2)	Been charged with a misdemeanor specified in 14B(1)?										
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Use a separate DRP for each event or <em>proceeding</em>. An event or <em>proceeding</em> may be reported for 
				more than one person or entity using one DRP. File with a completed Execution Page.
				<br/><br/>
				Multiple counts of the same charge arising out of the same event(s) should be reported on the same DRP. Unrelated
				criminal actions, including separate cases arising out of the same event, must be reported on separate DRPs. Use this
				DRP to report all charges arising out of the same event. One event may result in more than one affirmative answer to the
				above items.
				<br/><br/>
				If a <em>control affiliate</em> is an individual or organization registered through the CRD, such <em>control affiliate</em> need only 
				complete Part I of the <em>applicant'</em>s appropriate DRP (SBSE). Details of the event must be submitted on the <em>control affiliate'</em>s 
				appropriate DRP (BD) or DRP (U-4). If a <em>control affiliate</em> is an individual or organization not registered through the CRD, 
				provide complete answers to all the items on the <em>applicant'</em>s appropriate DRP (SBSE). The completion of this DRP does not 
				relieve the <em>control affiliate</em> of its obligation to update its CRD records. 
				<br/><br/>
				Applicants must attach a copy of each applicable court document (i.e., criminal complaint, information or indictment as well
				as judgment of conviction or sentencing documents) if not previously submitted through CRD (as they could be in the case
				of a <em>control affiliate</em> registered through CRD). Documents will not be accepted as disclosure in lieu of answering the
				questions on this DRP.
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse_drp1_part1">
		<h4 class="title1">PART I</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>person(s)</em> or entity(ies) for whom this DRP (SBSE) is being filed is (are):
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="not(contains(p3:drpFiledFor, 'affiliate'))">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;The <em>Applicant</em><br/>
					<xsl:choose>
						<xsl:when test="contains(p3:drpFiledFor, 'and one or')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;<em>Applicant</em> and one or more control <em>affiliate(s)</em><br/>
					<xsl:choose>
						<xsl:when test="not(contains(p3:drpFiledFor, 'Applicant'))">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;One or more control <em>affiliate(s)</em>
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				If this DRP is being filed for a <em>control affiliate</em>, give the full name of the 
					<em>control affiliate</em> below (for individuals, Last name, First name, Middle name).
					<br/>
				If the <em>control affiliate</em> is registered with the CRD, provide the CRD number. 
					If not, indicate "non-registered" by checking the appropriate checkbox.
			</p>
		</div>	
	</xsl:template>
	<xsl:template name="sbse_drp1_part2">
		<h4 class="title2">PART II</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					1. If charge(s) were brought against an organization over which the <em>control affiliate</em> exercise( d) control: Enter organization
					name, whether or not the organization was an investment-related business and the <em>control affiliate</em>'s position, title or relationship.
				</td>
				<td>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Organization Name
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:criminalDrpDetails/p3:organizationName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Is the organization an investment-related business
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:isEngagedInInvestmentRelatedBusiness = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:isEngagedInInvestmentRelatedBusiness = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						The <em>control affiliate</em>'s position, title, or relationship
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:criminalDrpDetails/p3:descRelationshipWithApplicant"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					2. Formal Charge(s) were brought in: (include name of Federal, Military, State or Foreign Court, Location of Court -- City
					or County <u>and</u> State or Country, Docket/Case number).
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:courtType = 'Federal Court'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Federal Court&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:courtType = 'Military Court'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Military Court&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:courtType = 'State Court'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;State Court&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:courtType = 'Foreign Court'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign Court&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:courtType = 'Other'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other					
				</td>
			</tr>
			<xsl:if test="p3:criminalDrpDetails/p3:courtType = 'Other'">
				<tr>
					<td class="label">
						<blockquote>
							If Other, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:criminalDrpDetails/p3:otherDescribe"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					<blockquote>
						Name of Federal, State, or Foreign Court
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:criminalDrpDetails/p3:nameOfCourt"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Location of Court
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City or County
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:criminalDrpDetails/p3:cityOrCounty"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State or Country
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" 
									select="p3:criminalDrpDetails/p3:stateOrCountry"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Docket /Case number
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:criminalDrpDetails/p3:docketOrCaseNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					3. Event Disclosure Detail (Use this for both organizational and individual charges.)
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						A.  Date First Charged (MM/DD/YYYY):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:criminalDrpDetails/p3:dateFirstCharged/p1:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						Specify if Date First Charged is Exact or needs an Explanation
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:dateFirstCharged/p1:exactOrExplanation = 'Exact'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Exact
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:dateFirstCharged/p1:exactOrExplanation = 'Explanation'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Explanation
				</td>
			</tr>
			<xsl:if test="not(p3:criminalDrpDetails/p3:dateFirstCharged/p1:exactOrExplanation = 'Exact')">
				<tr>
					<td class="label">
						<blockquote>
						<blockquote>
							If not exact, provide explanation:
						</blockquote>
						</blockquote>  
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:criminalDrpDetails/p3:dateFirstCharged/p1:explanationInfo"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					<blockquote>
						B. Event Disclosure Detail(include Charge(s)/Charge Description(s), 
						and for each charge provide:  <u>1</u>. number of counts, <u>2</u>. <em>felony</em> or <em>misdemeanor</em>, 
						<u>3</u>. plea for each charge, and <u>4</u>. product type if charge is <em>investment-related</em>) : 
					</blockquote>
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						List the Charge(s)/Charge Description(s):
					</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:criminalDrpDetails/p3:criminalCharge/p3:chargeDesc"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						<u>1</u>. Number of counts:
					</blockquote>
					</blockquote>  
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:criminalDrpDetails/p3:criminalCharge/p3:numberOfCounts"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						<u>2</u>. <em>felony or misdemeanor:</em>
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:criminalCharge/p3:felonyOrMisdemeanor = 'Felony'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;<em>felony</em>&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:criminalCharge/p3:felonyOrMisdemeanor = 'Misdemeanor'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;<em>misdemeanor</em>				
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						<u>3</u>. Plea for each charge:
					</blockquote>
					</blockquote> 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:criminalDrpDetails/p3:criminalCharge/p3:plea"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
					Is the charge <em>investment-related</em>
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:criminalCharge/p3:isInvestmentRelated = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:criminalCharge/p3:isInvestmentRelated = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						<u>4</u>. Product type if charge is <em>investment-related</em>:
					</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p3:criminalDrpDetails/p3:criminalCharge/p3:investmentProductType"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						C. Current status of the Event?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:eventCurrentStatus = 'Pending'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Pending&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:eventCurrentStatus = 'On Appeal'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;On Appeal&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:eventCurrentStatus = 'Final'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Final
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						D. Event Status Date (complete unless status is Pending) (MM/DD/YYYY):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:criminalDrpDetails/p3:eventStatusDate/p3:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<blockquote>
						Specify if Event status date is Exact or needs an Explanation
					</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:eventStatusDate/p3:exactOrExplanation = 'Exact'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Exact
					<xsl:choose>
						<xsl:when test="p3:criminalDrpDetails/p3:eventStatusDate/p3:exactOrExplanation = 'Explanation'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Explanation
				</td>
			</tr>
			<xsl:if test="not(contains(p3:criminalDrpDetails/p3:eventStatusDate/p3:exactOrExplanation,'Exact'))">
				<tr>
					<td class="label">
						<blockquote>
						<blockquote>
						If not exact, provide explanation:
						</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:criminalDrpDetails/p3:eventStatusDate/p3:explanationInfo"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					 Disposition Disclosure Detail: Include for each charge, <u>A</u>. Disposition Type 
					 [e.g., convicted, acquitted, dismissed, pretrial.], <u>B</u>. Date, <u>C</u>. Sentence/Penalty,
					  <u>D</u>. Duration [if sentence-suspension, probation, etc.], <u>E</u>. Start Date of Penalty, 
					  <u>F</u>. Penalty/Fine Amount and <u>G</u>. Date Paid.
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<u>A</u>. Disposition Type [e.g., convicted, acquitted, dismissed, pretrial.]:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p3:dispositionDisclosure/p3:dispositionType = 'Convicted'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Convicted&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:dispositionDisclosure/p3:dispositionType = 'Acquitted'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Acquitted&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:dispositionDisclosure/p3:dispositionType = 'Dismissed'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Dismissed&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:dispositionDisclosure/p3:dispositionType = 'Pretrial'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Pretrial&#160;&#160;
					<xsl:choose>
						<xsl:when test="p3:dispositionDisclosure/p3:dispositionType = 'Other'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other																				
				</td>
			</tr>
			<xsl:if test="p3:dispositionDisclosure/p3:dispositionType = 'Other'">
				<tr>
					<td class="label">
						<blockquote>
						<blockquote>
						Other Disposition Type
						</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p3:dispositionDisclosure/p3:dispositionTypeOtherDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					<blockquote>
						<u>B</u>. Date (MM/DD/YYYY):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:dispositionDisclosure/p3:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<u>C</u>. Sentence/Penalty:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:dispositionDisclosure/p3:sentencePenalty"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<u>D</u>. Duration  [if sentence- suspension, probation, etc.]:
					</blockquote>
				</td>
				<td>
					<div>
						<div class="fakeBox_drp1_duration">
							<xsl:value-of select="p3:dispositionDisclosure/p3:duration/p3:days"/>
						</div>
						&#160;of days&#160;
						<div class="fakeBox_drp1_duration">
							<xsl:value-of select="p3:dispositionDisclosure/p3:duration/p3:months"/>
						</div>
						&#160;of months&#160;
						<div class="fakeBox_drp1_duration">
							<xsl:value-of select="p3:dispositionDisclosure/p3:duration/p3:years"/>
						</div>
						&#160;of years
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<u>E</u>. Start Date of Penalty (MM/DD/YYYY):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:dispositionDisclosure/p3:startDatePenalty"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<u>F</u>. Penalty/Fine Amount:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select='format-number(p3:dispositionDisclosure/p3:penaltyFineAmount , "$###,###,###,##0.00")' />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<u>G</u>. Date Paid (MM/DD/YYYY):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p3:dispositionDisclosure/p3:datePaid"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					5. Provide a brief summary of the circumstances leading to the 
					charge(s) as well as the disposition. Include the relevant
					dates when the conduct which was the subject of the charge(s) 
					occurred. (The information must fit within the space provided.)
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p3:summaryOfCircumstances"/>
					</div>
				</td>
			</tr>
		</table>	
	</xsl:template>
</xsl:stylesheet>