<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsewfiler">

	<xsl:template name="sbse-w_execution">
		<h1><xsl:value-of select="$submissionType"/>: EXECUTION</h1>
		<div class="information" style="padding:0px 5px;" >
			<p>
				<h4 class="titleNumber">EXECUTION:</h4>
				The undersigned certifies that he/she has executed this form on behalf of, and with the authority of, 
				the security-based swap dealer or security-based swap participant, and that all information herein, including 
				any attachments hereto, is accurate, complete, and current. The undersigned and security-based swap dealer or 
				major security-based swap participant further certify that all the information previously submitted on Form SBSE, 
				Form SBSE-A, or Form SBSE-BD, as appropriate, is accurate and complete as of this date, and that the security-based 
				swap dealer's or major security-based swap participant's books and records will be preserved and available 
				for inspection as required by law.
			</p>
		</div>	
		
		<table role="presentation">
			<tr>
				<td class="label">
					<b>Print Name and Title</b>
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					Date (MM/DD/YYYY)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:execution/p:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Name
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:execution/p:nameOfPersonSigning"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					By: Signature
				</td>
				<td>	
					<div class="fakeBox3">
						<xsl:value-of select="p:execution/p:signature"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">					
					Title
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:execution/p:titleOfPersonSigning"/>
					</div>
				</td>
			</tr>	
		</table>		
	</xsl:template>
</xsl:stylesheet>