<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsewfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-w_header">
		<div class="pageHeader" style="border:none;">
			<p id="pageHeaderTitle">
				FORM SBSE-W
			</p>
			<p id="pageHeaderDetail">
				Request for Withdrawal from Registration <br/>
				as a Security-based Swap Dealer or Major <br/>
				Security-based Swap Participant
			</p>
		</div>		
	</xsl:template>
	<xsl:template name="sbse-w">
		<h1>SBSE-W</h1>
		<table role="presentation" id="ombHeaderTable">
			<tr>
				<td class="label" style="width:80%;padding:0px 0px 0px 315px;">
					<xsl:call-template name="sbse-w_header"/>
				</td>
				<td class="label" style="width:20%;">
					<xsl:call-template name="sbse-w_ombInformation"/>
				</td>
			</tr>
		</table>
		<div class="warning">
			<p>
				INTENTIONAL MISSTATEMENTS OR OMISSIONS OF FACTS MAY CONSTITUTE FEDERAL CRIMINAL VIOLATIONS.
				<font style="font-weight:lighter">
					<em>See</em> 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)
				</font>
				<br/><br/> 
				NOTE:
				<font style="font-weight:lighter">
					Prior to filing a notice of withdrawal from registration on Form SBSE-W, an entity must update any 
					incomplete or inaccurate information contained on Form SBSE, Form SBSE-A, or Form SBSE-BD, as appropriate [17 CFR 15Fb3-2(a)]. 
				</font>
			</p>
		</div>
		<table role="presentation">
			<tr>
				<td class="label">
					1.
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>A. Full name of Security-based Swap Dealer or Major Security-based Swap Participant:
					</blockquote> 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:sbseW/p:fullName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>B. IRS Emp. Ident. No.:
					</blockquote> 
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:irsEmplIdentNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>C. Name under which business is conducted, if different:
					</blockquote> 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:sbseW/p:nameIfDifferent"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>D. Firm SEC, NFA, and/or CRD No.:
					</blockquote> 
				</td>
				<td>&#160;</td>
			</tr>
			<xsl:choose>
				<xsl:when test="count(p:sbseW/p:secFileNumber) &gt; 0">
					<xsl:for-each select="p:sbseW/p:secFileNumber">
						<tr>
							<td class="label">
								<blockquote>
									<blockquote>
										SEC File Number
									</blockquote>
								</blockquote>
							</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="."/>
								</div>
							</td>
						</tr>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td class="label">
							<blockquote>
								<blockquote>
									SEC File Number
								</blockquote>
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
							</div>
						</td>
					</tr>
				</xsl:otherwise>
			</xsl:choose>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							NFA
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:nfa"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							CRD Number
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:crdNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>E. Firm main address: Number and Street
					</blockquote> 
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Street Address 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:mainAddress/p1:street1"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Street Address 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:mainAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:mainAddress/p1:city"/>
					</div>
				</td>
			</tr>					
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State/Country:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p:sbseW/p:mainAddress/p1:stateOrCountry"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Zip + 4 Postal Code:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:mainAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>F. Mailing address, if different: Number and Street
					</blockquote> 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Street Address 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:mailingAddress/p1:street1"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Street Address 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:mailingAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:mailingAddress/p1:city"/>
					</div>
				</td>
			</tr>			
						
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State/Province/Country:
						</blockquote>
					</blockquote>
				</td>			
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p:sbseW/p:mailingAddress/p1:stateOrCountry"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Zip/ Postal Code:
						</blockquote>
					</blockquote>
				</td>				
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:mailingAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Area Code / Telephone No.:
						</blockquote>
					</blockquote>
				</td>						
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:telephoneNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					2. Withdrawing from Registration as a: 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p:sbseW/p:registrationType, 'Dealer')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Security-based Swap Dealer&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:sbseW/p:registrationType, 'Participant')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Major Security-based Swap Participant				
				</td>
			</tr>
			<tr>
				<td class="label">
					3. Date firm ceased business: 
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:dateCeasedBusiness"/>
					</div>
				</td>
			</tr>	
			<!-- VARIABLES BEGIN -->
			<xsl:variable name="sbse-w_item4_1">
				<xsl:for-each select="p:sbseW/p:reasonsToWithdraw/p:reasonToWithdraw">
					<xsl:if test="contains(., 'Winding down')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-w_item4_2">
				<xsl:for-each select="p:sbseW/p:reasonsToWithdraw/p:reasonToWithdraw">
					<xsl:if test="contains(., 'No longer doing security')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-w_item4_3">
				<xsl:for-each select="p:sbseW/p:reasonsToWithdraw/p:reasonToWithdraw">
					<xsl:if test="contains(., 'Have effected less security')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-w_item4_4">
				<xsl:for-each select="p:sbseW/p:reasonsToWithdraw/p:reasonToWithdraw">
					<xsl:if test="contains(., 'as a security')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-w_item4_5">
				<xsl:for-each select="p:sbseW/p:reasonsToWithdraw/p:reasonToWithdraw">
					<xsl:if test="contains(., 'as a major security')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-w_item4_6">
				<xsl:for-each select="p:sbseW/p:reasonsToWithdraw/p:reasonToWithdraw">
					<xsl:if test="contains(., 'Other')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES END -->		
			<tr>
				<td class="label">
					4. Reason security-based swap dealer or major security-based swap participant is seeking to withdraw from SEC registration: 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse-w_item4_1 , 'Winding down')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Winding down all business<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-w_item4_2 , 'No longer doing security')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No longer doing security-based swap business in U.S.<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-w_item4_3 , 'Have effected less security')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Have effected less security-based swap business for previous 
					four quarters and no longer fit definition of major security-based swap participant <br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-w_item4_4 , 'as a security')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Ceasing business as a security-based swap dealer <br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-w_item4_5 , 'as a major security')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Ceasing business as a major security-based swap participant<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-w_item4_6 , 'Other')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other 
				</td>
			</tr>
			<xsl:if test="contains($sbse-w_item4_6 , 'Other')">		
				<tr>
					<td class="label">
						<blockquote>(describe):
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:sbseW/p:description"/>
						</div>
					</td>
				</tr>
			</xsl:if>		
			<tr>
				<td class="label">
					5. Does the security-based swap dealer or major security-based swap participant hold any segregated counterparty collateral?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:sbseW/p:isHoldCollateral = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:sbseW/p:isHoldCollateral = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<xsl:if test="p:sbseW/p:isHoldCollateral = 'Y'">
				<tr>
					<td class="label">
						<blockquote>A. Number of counterparties whose collateral is held:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:sbseW/p:numberOfCounterparties"/>
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>B. Amount of money held as collateral: 
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select='format-number(p:sbseW/p:amountOfMoney , "$###,###,###,##0.00")' />
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>C. Market value of securities held as collateral: 
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select='format-number(p:sbseW/p:marketValue , "$###,###,###,##0.00")' />
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>D. Describe arrangements made for return of collateral: 
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:sbseW/p:describeArrangements"/>
						</div>
					</td>
				</tr>
			</xsl:if>	
			<tr>
				<td class="label">
					6. Is the security-based swap dealer or major security-based swap participant currently the subject of or named in any investment-related: 
				</td>
				<td></td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>- investigation 
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:sbseW/p:isInvestigation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:sbseW/p:isInvestigation = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>- customer-initiated complaint  
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:sbseW/p:isComplaint = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:sbseW/p:isComplaint = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>- private civil litigation 
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:sbseW/p:islitigation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:sbseW/p:islitigation = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>			
		</table>
	
		<table role="presentation">
			<tr>
				<td class="label">
					7.
				</td>
				<td>&#160;</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>Name and Address of the Person who will have Custody of Books and Records:
					</blockquote> 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Firm or Individual?
						</blockquote>
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:sbseW/p:firmOrIndividual = 'Firm'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Firm
					<xsl:choose>
						<xsl:when test="p:sbseW/p:firmOrIndividual = 'Individual'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Individual	
				</td>
			</tr>
			<xsl:if test="p:sbseW/p:firmOrIndividual = 'Firm'">
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								<blockquote>
									Name of the Person who will have Custody of Books and Records:
								</blockquote>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:sbseW/p:firmName"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p:sbseW/p:firmOrIndividual = 'Individual'">
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								<blockquote>
									Prefix:
								</blockquote>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:sbseW/p:individualName/p1:prefix"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								<blockquote>
									First Name:
								</blockquote>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:sbseW/p:individualName/p1:firstName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								<blockquote>
									Middle Name:
								</blockquote>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:sbseW/p:individualName/p1:middleName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								<blockquote>
									Last Name;
								</blockquote>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:sbseW/p:individualName/p1:lastName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							<blockquote>
								<blockquote>
									Suffix:
								</blockquote>
							</blockquote>
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:sbseW/p:individualName/p1:suffix"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Street Address 1:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:personAddress/p1:street1"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Street Address 2:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:personAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:personAddress/p1:city"/>
					</div>
				</td>
			</tr>			
						
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State/Province/Country:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p:sbseW/p:personAddress/p1:stateOrCountry"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Zip/ Postal Code:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:personAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Area Code / Telephone No.:
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:personTelephoneNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>Address where the Books and Records will be Located, if Different:
					</blockquote> 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label"><blockquote><blockquote>Street Address 1:</blockquote></blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:locAddress/p1:street1"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label"><blockquote><blockquote>Street Address 2:</blockquote></blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:locAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			
			<tr>
				<td class="label"><blockquote><blockquote>City:</blockquote></blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:sbseW/p:locAddress/p1:city"/>
					</div>
				</td>
			</tr>			
						
			<tr>
				<td class="label"><blockquote><blockquote>State/Province/Country:</blockquote></blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" select="p:sbseW/p:locAddress/p1:stateOrCountry"/>
						</xsl:call-template>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label"><blockquote><blockquote>Zip/ Postal Code:</blockquote></blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:sbseW/p:locAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>			
		</table>
	</xsl:template>
</xsl:stylesheet>