<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsecfiler">

	<xsl:import href="util.xsl" />

	<xsl:output 
		method="html" 
		indent="no" 
		encoding="iso-8859-1"
		doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd" />

	<xsl:variable name="submissionType"  select="p:edgarSubmission/p:headerData/p:submissionType" />

	<xsl:template match="/">
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="css/SDR_print.css" />
				<style>
					.warning {
						font-weight:bold;   
						padding:10px; 
						margin:5px 0px;
						color:#302000;
						font-size:0.9em;
					}
					/* informations */
					.information, .informationNoBorder {
						font-weight:lighter   
						padding:10px;
						color:#302000;
						font-size:0.9em;
					}
					img {
						vertical-align:text-top;
					}
					.information {
						margin:5px 0px;
					}
					.informationNoBorder{
						margin:5px 0px; 
					}
					/* titles (order by font size)*/
					.title1, .title2, .title3, .titleNumber {
						font-family: Arial, Helvetica, sans-serif;
					    text-align: left;
					    line-height: 1.5;				
					}									
					.title1 { /* Largest title */
						margin: 10px 0px;
					    font-size: 1.3em;
					}
					.title2 { /* Second largest title */
						margin: 10px;
					    font-size: 1.1em;
					}	
					.title3 { /* Third largest title */
						margin: 10px 20px;
					    color: black;
					    font-size: 1.0em;
					}
					.titleNumber {
						margin: 10px 0px;
						line-height: 0.8;
					}
					.titleWhite {
						background-color: white;
						width: 25%;
					}
					h4{
						vertical-align:middle;
					}
					.pageHeader {
						font-weight:bold;   
						padding:10px; 
						margin:5px 0px;
						background-color:#e0e0ff;
						border:2px solid #42638F;
						color:#302000;
						text-align: center;
						vertical-align: middle;					
					}				
					#pageHeaderTitle {
						font-size:1.2em;
					}
					#pageHeaderDetail {
						font-size:1.1em;
					}
					#pageHeaderQuestion{
						font-weight:lighter;
						font-size:1.0em;
					}
					#twoHeaders .title1, .title2{
						display:inline;
					}
					#pageHeaderTitleOMB{
						font-size:1.0em;
					}
					#pageHeaderOMBNumber {
						font-size:0.9em;
					}
					#pageHeaderOMBEst {
						font-size:0.8em;
					}
					#ombHeaderTable {
						border-collapse: collapse;
						border:2px solid #42638F;
					}
					#ombHeaderTable td {
						vertical-align: middle;
					}
					#header .side {
						font-weight:lighter;
					}
					.fakeBox3, .fakeBox {
						width: 740px;
						position:relative;
					}
					.fakeBox {
						border-top: 2px solid #999;
					}
				</style>
			</head>

			<body lang="en-US" text="#000000" bgcolor="#ffffff">
				<div style="display:none">
					schema version:
					<xsl:value-of select="string(p:edgarSubmission/p:schemaVersion)"/>
				</div>
			</body>
		</html>
		
		<xsl:apply-templates select="p:edgarSubmission/p:headerData/p:filerInfo"/>
		<xsl:apply-templates select="p:edgarSubmission"/>
		<xsl:apply-templates select="p:edgarSubmission/p:documents"/>
	</xsl:template>

	<!-- Header Template START -->
	<xsl:template name="header" match="p:edgarSubmission/p:headerData/p:filerInfo">
		<div id="info">
			<div class="contentwrapper">
				<div class="content">
					<h1><xsl:value-of select="$submissionType"/>: Filer Information</h1>
					<table role="presentation" class="filerInformation">		
						<tr>
							<td class="label">Filer CIK</td>
							<td>
								<div class="fakeBox2">
									<xsl:choose>
										<xsl:when test="contains($submissionType , '-BD')">
											<xsl:value-of select="p:filer/p:filerCredentials/p:cik" />
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="p:filer/p:filerCredentials/p:filerCik" />
										</xsl:otherwise>
									</xsl:choose>
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Filer CCC</td>
							<td>
								<div class="fakeBox2">				
									**********
								</div>
							</td>
						</tr>				
						<tr>
							<td class="label">Is this a LIVE or TEST Filing?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:liveTestFlag = 'LIVE'">
										<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;LIVE
								<xsl:choose>
									<xsl:when test="p:liveTestFlag = 'TEST'">
										<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
									</xsl:when>											
									<xsl:otherwise>
										<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
									</xsl:otherwise>
								</xsl:choose>&#160;TEST
							</td>
						</tr>
						<tr>
							<td class="label">Would you like a Return Copy?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:returnCopyFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td>
								<h4>Submission Contact Information</h4>
							</td>
						</tr>
						<tr>
							<td class="label">Name</td>
							<td>
								<div class="fakeBox">
									<xsl:value-of select="p:contact/p:contactName" />
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">Phone</td>
							<td>
								<div class="fakeBox2">
									<xsl:value-of select="p:contact/p:contactPhoneNumber" />
								</div>
							</td>
						</tr>

						<tr>
							<td class="label">E-Mail Address</td>
							<td>			
								<div class="fakeBox">
									<xsl:value-of select="p:contact/p:contactEmailAddress" />
								</div>
							</td>
						</tr>
					
						<tr>
							<td class="label">Notify via Filing Website only?</td>
							<td>
								<xsl:choose>
									<xsl:when test="p:flags/p:overrideInternetFlag = 'true'">
										<img src="Images/box-checked.jpg" alt="Checkbox checked" />
									</xsl:when>
									<xsl:otherwise>
										<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						
						<xsl:choose>
							<xsl:when test="count(p:notifications/p:notificationEmailAddress) &gt; 0">
								<xsl:for-each select="p:notifications/p:notificationEmailAddress">
									<tr>
										<td class="label">Notification E-mail Address</td>
										<td>
											<div class="fakeBox">
												<xsl:value-of select="." />
											</div>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:when>
							<xsl:otherwise>
								<tr>
									<td class="label">Notification E-mail Address</td>
									<td>
										<div class="fakeBox"></div>
									</td>
								</tr>
							</xsl:otherwise>
						</xsl:choose>
					</table>
				</div>
			</div>
		</div>
	</xsl:template>
	
	<xsl:template name="formData" match="p:edgarSubmission">
		<xsl:call-template name="sbse-c"/>
	</xsl:template>
	
	<xsl:template name="documentsData" match="p:edgarSubmission/p:documents">
		<div style="display:none;">	
			<xsl:call-template name="sbse_documents"/>
		</div>
	</xsl:template>
	
	<xsl:include href="SBSE-C.xsl"/>
	<xsl:include href="SBSE_documents.xsl" />
</xsl:stylesheet>