<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsecfiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-c">
		<h1>SBSE-C: Certification 1</h1>
		<table role="presentation" id="ombHeaderTable">
			<tr>
				<td class="label" style="width:80%;padding:0px 0px 0px 315px;">
					<div class="pageHeader" style="border:none;">
						<p id="pageHeaderTitle">
							FORM SBSE-C
						</p>
						<p id="pageHeaderDetail">
							Certification
						</p>
						<p id="pageHeaderQuestion">
							<em>Applicant</em> Name:&#160;
							<b><u><xsl:value-of select="p:formData/p:certificationOne/p:applicantName"/></u></b>
						</p>
						<p id="pageHeaderQuestion">
							Date:&#160;
							&#160;&#160;
							SEC Filer No:&#160;
						</p>
					</div>
				</td>
				<td class="label" style="width:20%;">
					<table role="presentation" id="header">
						<tr>
							<td class="title">OMB APPROVAL</td>
						</tr>	
						<tr>
							<td class="side" >
								<p>OMB Number:&#160;&#160;3235-AL05</p>
								<hr/>
								<p>Estimated average burden hours per response: 41 hours</p>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
		<!-- certification 1 BEGINS -->
		<div class="warning">
			<p>
				INTENTIONAL MISSTATEMENTS OR OMISSIONS OF FACTS MAY CONSTITUTE FEDERAL CRIMINAL VIOLATIONS.
				<br/><br/>
				<font style="font-weight:lighter">
					See 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)
				</font>
			</p>
		</div>
		<div class="information">
			<p>
				Instructions:
				<br/>
				<ul style="list-style-type:none;font-weight:lighter">
					<li>This Certification 1 must be signed by a senior officer of the applicant.</li>
				</ul>
				<br/>
				&#160;&#160;I certify that -
				<div style="padding:3px"/>
				<ul style="list-style-type:none;font-weight:lighter">
					<li>(1) after due inquiry, I have reasonably determined that the applicant has 
						developed and implemented written policies and procedures reasonably designed 
						to prevent violation of federal securities laws and the rules thereunder, and </li>
					<li>(2) I have documented the process by which I reached such determination. </li>
				</ul>
			</p>
		</div>
		
		<table role="presentation">
			<tr>
				<td class="label">
					Applicant Name:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationOne/p:cerApplicantName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Date:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:certificationOne/p:cerDate"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Signature of Senior Officer:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationOne/p:signature"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Name of Senior Officer:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationOne/p:name"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Title of Senior Officer
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationOne/p:title"/>
					</div>
				</td>
			</tr>
		</table>
		<!-- certification 1 ENDS -->
		
		<!-- certification 2 BEGINS -->
		<h1>SBSE-C: Certification 2</h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE-C
			</p>
			<p id="pageHeaderDetail">
				Certification
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;
				<b><u><xsl:value-of select="p:formData/p:certificationTwo/p:applicantName"/></u></b>
			</p>
			<p id="pageHeaderQuestion">
				Date:&#160;
				&#160;&#160;
				SEC Filer No:&#160;
			</p>
		</div>
		<div class="warning">
			<p>
				INTENTIONAL MISSTATEMENTS OR OMISSIONS OF FACTS MAY CONSTITUTE FEDERAL CRIMINAL VIOLATIONS.
				<br/><br/>
				<font style="font-weight:lighter">
					See 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)
				</font>
			</p>
		</div>
		<div class="information">
			<p>
				Instructions:
				<ul style="list-style-type:none;font-weight:lighter">
					<li>This certification must be signed by the <em>applicant</em>'s Chief Compliance 
						Officer designated pursuant to Exchange Act Section 15F(k) or by his or her designee.</li>
					<li>For purposes of this Form, the term <em>associated person</em> shall have the meaning as 
						specified in Section 3(a)(70) of the Exchange Act [15 U.S.C. 78c(a)(70)].</li>
				</ul>
				<br/>
				&#160;&#160;The <em>applicant</em> certifies that it -
				<div style="padding:3px"/>
				<ul style="list-style-type:none;font-weight:lighter">
					<li>(a) has performed background checks on all of its <em>associated persons</em> who are 
						natural persons and who effect or are involved in effecting security-based swaps on its behalf, and</li>
					<li>(b) neither knows, nor in the exercise of reasonable care should have known, that any <em>associated 
						person</em> who effects or is involved in effecting security-based swaps on its behalf is subject to a 
						statutory disqualification, as described in Sections 3(a)(39)(A) through (F) of the Securities Exchange 
						Act of 1934 (15 U.S.C. 78c(a)(39)(A) – (F)), unless otherwise specifically provided by rule, regulation 
						or order of the Commission. </li>
				</ul>
			</p>
		</div>

		<table role="presentation">
			<tr>
				<td class="label">
					Applicant Name:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationTwo/p:cerApplicantName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Date:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:certificationTwo/p:cerDate"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Signature of Chief Compliance Officer or Designee:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationTwo/p:signature"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Name of Chief Compliance Officer or Designee:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationTwo/p:name"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					If Designee, Title of Designee:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:certificationTwo/p:titleIfDesignee"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>