<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsebdfiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-bd_tab1">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - Page 1</h1>
		
		<table role="presentation" id="ombHeaderTable">
			<tr>
				<td class="label" style="width:80%;padding:0px 0px 0px 315px;">			
					<div class="pageHeader" style="border:none;">
						<p id="pageHeaderTitle">
							FORM SBSE-BD
						</p>
						<p id="pageHeaderDetail">
							Application for Registration as a Security-based <br/> 
							Swap Dealer and Major Security-based Swap Participant <br/>
							that is Registered as a Broker-Dealer 
						</p>
					</div>
				</td>
				<td class="label" style="width:20%;">
					<table role="presentation" id="header">
						<tr>
							<td class="title">OMB APPROVAL</td>
						</tr>	
						<tr>
							<td class="side" >
								<p>OMB Number:&#160;&#160;3235-AL05</p>
								<hr/>
								<p>Estimated average burden hours per response – initial: 10.5 hours</p>
								<hr/> 
								<p>Estimated average burden hours per response – amendment: 1 hour</p>
								<hr/>  
								<p>Estimated average additional burden hours for Schedule F – initial: 1.5 hours</p>
								<hr/>
								<p>Estimated average additional burden hours per response – amendment: 1.5 hours</p>
							</td>
						</tr>
					</table>						
				</td>
			</tr>
		</table>
			
		<div class="warning">
			<u>WARNING:</u>
			<font style="font-weight:lighter">
				Failure to keep this form current and to file accurate supplementary information on a timely basis, 
				or the failure to keep accurate books and records or otherwise to comply with the provisions of law 
				applying to the conduct of business as an SBS Entity, would violate the Federal securities laws and 
				may result in disciplinary, administrative, injunctive or criminal action.
			</font>
			<br/><br/>		
			<b>INTENTIONAL MISSTATEMENTS OR OMISSIONS OF FACTS MAY CONSTITUTE FEDERAL CRIMINAL VIOLATIONS. </b>
			<br/><br/>
			<font style="font-weight:lighter">
				See 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)
			</font>
		</div>

		<h4 class="titleNumber">1. Exact name and CRD number of the <em>applicant:</em></h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Full name of the <em>applicant:</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:applicantOne/p:fullApplicantName"/>	
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					B. CRD No.:
				</td>
				<td>
					<div class="fakeBox2">	
						<xsl:value-of select="p:formData/p:applicantOne/p:crdNo"/>			
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						UIC No. (if any):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">	
						<xsl:value-of select="p:formData/p:applicantOne/p:uicNumber"/>			
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					C. Website/URL:
				</td>
				<td>
					<div class="fakeBox3">		
						<xsl:value-of select="p:formData/p:applicantOne/p:websiteUrl"/>		
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					D. Contact Employee:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Prefix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:prefix"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						First Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:firstName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Middle Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:middleName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Last Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:lastName"/>
					</div>
				</td>
			</tr>
				
			<tr>
				<td class="label">
					<blockquote>
						Suffix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:suffix"/>
					</div>
				</td>
			</tr>	
				
			<tr>
				<td class="label">
					<blockquote>
						Title:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:title"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Phone:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:phone"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						Email Address:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:contactEmployee/p:emailAddress"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					E. Chief Compliance Officer designated by the applicant in accordance with Exchange Act Section 15F(k):
				</td>
				<td></td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						Prefix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:prefix"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						First Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:firstName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Middle Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:middleName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Last Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:lastName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Suffix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:suffix"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						Title:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:title"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Phone:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:phone"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						Email Address:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicantOne/p:chiefComplianceOfficer/p:emailAddress"/>
					</div>
				</td>
			</tr>				
		</table>
	
		<h4 class="titleNumber">2.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>applicant</em> is registering as a security-based swap dealer:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isSwapDealer = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isSwapDealer = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
			<tr>
				<td class="label">
					B. The <em>applicant</em> is registering as a major security-based swap participant:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isSwapParticipant = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isSwapParticipant = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
			<xsl:if test="p:formData/p:applicantOne/p:isSwapParticipant = 'Y'">
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse-bd_item2b_1">
					<xsl:for-each select="p:formData/p:applicantOne/p:swapOptions/p:swapOption">
						<xsl:if test="contains(., 'swap position')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-bd_item2b_2">
					<xsl:for-each select="p:formData/p:applicantOne/p:swapOptions/p:swapOption">
						<xsl:if test="contains(., 'counterparty exposure')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-bd_item2b_3">
					<xsl:for-each select="p:formData/p:applicantOne/p:swapOptions/p:swapOption">
						<xsl:if test="contains(., 'capital position')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						<blockquote>
							Because it: (check all that apply)
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item2b_1 ,'swap position')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;maintains a substantial security-based swap position<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item2b_2 ,'counterparty exposure')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;has substantial counterparty exposure<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item2b_3 ,'capital position')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;is highly leveraged relative to its capital position
					</td>
				</tr>
			</xsl:if>
		</table>
	
		<h4 class="titleNumber">3.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>applicant</em> is presently registered with the Commodity Futures Trading Commission as a:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:registeredAs = 'Swap Dealer'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Swap Dealer&#160;
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:registeredAs = 'Major Swap Participant'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Major Swap Participant				
				</td>
			</tr>
			<tr>
				<td class="label">
					B. The <em>applicant</em> is registering with the Commodity Futures Trading Commission as a:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:registeringAs = 'Swap Dealer'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Swap Dealer&#160;
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:registeringAs = 'Major Swap Participant'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Major Swap Participant					
				</td>
			</tr>
		</table>
	
		<h4 class="titleNumber">4.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> subject to regulation by a prudential regulator, as defined in Sec. 1a(39) of the Commodity Exchange Act.
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isSubjectToRegulator = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isSubjectToRegulator = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<xsl:if test="p:formData/p:applicantOne/p:isSubjectToRegulator = 'Y'">
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse-bd_item4_1">
					<xsl:for-each select="p:formData/p:applicantOne/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Reserve Board')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-bd_item4_2">
					<xsl:for-each select="p:formData/p:applicantOne/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Comptroller of the Currency')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-bd_item4_3">
					<xsl:for-each select="p:formData/p:applicantOne/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Deposit Insurance Corporation')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-bd_item4_4">
					<xsl:for-each select="p:formData/p:applicantOne/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Credit Administration')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-bd_item4_5">
					<xsl:for-each select="p:formData/p:applicantOne/p:prudentialRegulators/p:prudentialRegulator">
						<xsl:if test="contains(., 'Finance Agency')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<!-- VARIABLES END -->		
				<tr>
					<td class="label">
						<blockquote>
							If "yes," identify the prudential regulator:
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item4_1 , 'Reserve Board')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Reserve Board	<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item4_2 , 'Comptroller of the Currency')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Office of the Comptroller of the Currency	<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item4_3 , 'Deposit Insurance')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Deposit Insurance Corporation	<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item4_4 , 'Farm Credit')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Farm Credit Administration<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-bd_item4_5 , 'Housing Finance')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Housing Finance Agency				
					</td>
				</tr>
			</xsl:if>
		</table>
	
		<h4 class="titleNumber">5.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> registered with the Commission as an over-the-counter derivatives dealer?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isDerivativesDealer = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isDerivativesDealer = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No				
				</td>
			</tr>
		</table>
		
		<h4 class="titleNumber">6.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Briefly describe the <em>applicant</em>'s business:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:applicantOne/p:describeBusiness"/>
					</div>
				</td>
			</tr>
		</table>
		
		<h4 class="titleNumber">7.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> registered with a foreign financial regulatory authority?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isForeignRegulatory = 'Y'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicantOne/p:isForeignRegulatory = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				If "<em>yes,</em>" list all such registrations on Schedule F, Page 1, Section II.
			</p>
		</div>
	</xsl:template>
</xsl:stylesheet>