<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsebdfiler">

	<xsl:template name="sbse-bd_execution">
		<h1><xsl:value-of select="$submissionType"/>: EXECUTION</h1>
		<div class="information" style="padding:0px 5px;">
			<p>
				<h4 class="titleNumber">EXECUTION:</h4>
				The applicant consents that service of any civil action brought by or notice of any proceeding 
				before the Securities and Exchange Commission in connection with the applicant's security-based 
				swap activities, unless the applicant is a nonresident SBS Entity, may be given by registered or 
				certified mail or confirmed telegram to the applicant's contact employee at the main address, or 
				mailing address if different, given in Items 1E and 1F. If the applicant is a nonresident SBS Entity, 
				it must complete Schedule F to designate a U.S. agent for service of process. 
				<br/><br/>
				The undersigned certifies that he/she has executed this form on behalf of, and with the authority 
				of, said applicant. The undersigned and applicant represent that the information and statements 
				contained herein, including schedules attached hereto, and other information filed herewith are current, 
				true and complete. The undersigned and applicant further represent that to the extent any information 
				previously submitted is not amended such information is currently accurate and complete. 
			</p>
		</div>	
		
		<table role="presentation">
			<tr>
				<td class="label">
					Date
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:execution/p:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Name of Applicant
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:execution/p:nameOfApplicant"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					By: Signature
				</td>
				<td>	
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:execution/p:signature"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
						Name of Person Signing on <em>Applicant's</em> behalf
					
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:execution/p:nameOfPersonSigning"/>
					</div>
				</td>
			</tr>						
			<tr>
				<td class="label">
					Title of Person Signing on <em>Applicant's</em> behalf
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:execution/p:titleOfPersonSigning"/>
					</div>
				</td>
			</tr>	
		</table>		
	</xsl:template>
</xsl:stylesheet>