<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbsebdfiler"
	xmlns:p1="http://www.sec.gov/edgar/common">
	
	<xsl:template name="sbse-bd_tab_scheduleF">
		<h1><xsl:value-of select="$submissionType"/>: SCHEDULE F of Form SBSE-BD <br/></h1>
		<h4 class="title1">NONRESIDENT SECURITY-BASED SWAP DEALERS AND MAJOR SECURITY-BASED SWAP PARTICIPANTS</h4>

		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE-BD
			</p>
			<p id="pageHeaderDetail">
				Application for Registration as a Security-based <br/> 
				Swap Dealer and Major Security-based Swap Participant <br/>
				that is Registered as a Broker-Dealer 
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;
				<b><u><xsl:value-of select="p:formData/p:scheduleF/p:applicantName"/></u></b>
			</p>		
			<p id="pageHeaderQuestion">
				Date:&#160;
				&#160;&#160;
				Firm SEC No:&#160;
			</p>
		</div>			
		<div class="information">
			<h4 class="title3" style="font-style:normal;margin:10px 5px">
				Section I <em>Service of Process and Certification Regarding Access to Records</em>
			</h4>
			<p>
				Each nonresident security-based swap dealer and non-resident security-based 
				swap participant shall use Schedule F to identify its United States agent 
				for service of process and the certify that it can as a matter of law, and will -
				<br/><br/>
				(5) provide the Commission with prompt access to its books and records, and<br/>
				(6) submit to onsite inspection and examination by the Commission.
			</p>
		</div>
		<xsl:if test="count(p:formData/p:scheduleF/p:serviceOfProcess/p:firmOrIndividual) &gt; 0">
			<div class="information">
				<h4 class="title2">1. Service of Process:</h4>
				<h4 class="title3">A. Name of United States person <em>applicant</em> designates and appoints as agent for service of process</h4>
			</div>
			<table role="presentation">
				<xsl:if test="p:formData/p:scheduleF/p:serviceOfProcess/p:firmOrIndividual = 'Firm'">
					<tr>
						<td class="label">
							Name
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:firmName"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<xsl:if test="p:formData/p:scheduleF/p:serviceOfProcess/p:firmOrIndividual = 'Individual'">
					<tr>
						<td class="label">
							Prefix
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:individualName/p1:prefix"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Last Name
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:individualName/p1:lastName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							First Name
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:individualName/p1:firstName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Middle Name
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:individualName/p1:middleName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Suffix
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:individualName/p1:suffix"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</table>
		</xsl:if>
		<xsl:if test="count(p:formData/p:scheduleF/p:serviceOfProcess/p:firmName) &gt; 0">
			<div class="information">
				<h4 class="title3">B. Address of United States person <em>applicant</em> designates and appoints as agent for service of process</h4>
			</div>
			<table role="presentation">
				<tr>
					<td class="label">
						Street Address 1
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:address/p1:street1"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Street Address 2
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:address/p1:street2"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						City
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:address/p1:city"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						State/Country
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param 
									name="stateCode" 
									select="p:formData/p:scheduleF/p:serviceOfProcess/p:address/p1:stateOrCountry"/>
							</xsl:call-template>
						</div>							
					</td>
				</tr>
				<tr>
					<td class="label">
						Zip/Postal Code
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleF/p:serviceOfProcess/p:address/p1:zipCode"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:if>
		<xsl:if test="count(p:formData/p:scheduleF/p:serviceOfProcess/p:firmOrIndividual) &gt; 0">
			<div class="information">
				<p>
					The above identified agent for service of process may be served any process, pleadings, subpoenas, or other papers in
					<br/>
					(a) any investigation or administrative proceeding conducted by the Commission that relates to the <em>applicant</em> 
					or about which the <em>applicant</em> may have information; and
					<br/>
					(b) any civil or criminal suit or action or proceeding brought against the <em>applicant</em> or to which the <em>applicant</em> 
					has been joined as defendant or respondent, in any appropriate court in any place subject to the jurisdiction of any state or of 
					the United States or of any of its territories or possessions or of the District of Columbia, to enforce the Exchange Act. 
					The <em>applicant</em> has stipulated and agreed that any such suit, action or administrative proceeding may be commenced by 
					the service of process upon, and that service of an administrative subpoena shall be effected by service upon the above-named 
					Agent for Service of Process, and that service as aforesaid shall be taken and held in all courts and administrative tribunals 
					to be valid and binding as if personal service thereof had been made.
				</p>
			</div>
			<div class="information">
				<h4 class="title2">2. Certification regarding access to records:</h4>
			</div>
			<div class="informationNoBorder">
				<p>
					<em>Applicant</em> can as a matter of law, and will;
					<br/>
					(5) provide the Commission with prompt access to its books and records, and<br/>
					(6) submit to onsite inspection and examination by the Commission.
					<br/><br/>		
					<em>Applicant must attach to this Form SBSE a copy of the opinion of counsel it is required to obtain in accordance with paragraph 
					<br/>
					(c)(1)(ii) or (c)(2) of Exchange Act Rule 15Fb2-4, as appropriate [paragraphs (c)(1)(ii) or (c)(2) of 17 CFR 240. 15Fb2-4].
					</em>
				</p>
			</div>	
			<table role="presentation">
				<tr>
					<td class="label">
						Signature:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:formData/p:scheduleF/p:signature"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Name:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:formData/p:scheduleF/p:signerName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Title:
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:formData/p:scheduleF/p:signerTitle"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Date:
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleF/p:signerDate"/>
						</div>
					</td>
				</tr>
			</table>
		</xsl:if>
		<div class="information">
			<h4 class="title3" style="font-style:normal;margin:10px 5px">
				Section II <em>Registration with Foreign Financial Regulatory Authorities</em>
			</h4>
			<p>
				<b><em>
				Complete this Section for Registration with Foreign Financial Regulatory Authorities relating to ITEM 7. 
				</em></b>
				Each security- based swap dealer and major security-based swap participant that is registered with 
				a foreign financial regulatory authority must list on Section II of this Schedule F, for each foreign 
				financial regulatory authority with which it is registered, the following information:
			</p>
		</div>
		<xsl:choose>	
			<xsl:when test="count(p:formData/p:scheduleF/p:foreignFinancialReg) &gt; 0">
				<xsl:for-each select="p:formData/p:scheduleF/p:foreignFinancialReg">
					<table role="presentation">
						<tr>
							<td class="label">
								English Name of Foreign Financial Regulatory Authority
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p:regulatoryAuthName"/>
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">
								Foreign Registration No. (if any)
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p:foreignRegistrationNo"/>
								</div>
							</td>
						</tr>
						<tr>
							<td class="label">
								English Name of Country:
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:call-template name="stateDescription">
										<xsl:with-param 
											name="stateCode" 
											select="p:regulatoryAuthCountry"/>
									</xsl:call-template>					
								</div>
							</td>
						</tr>
					</table>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<table role="presentation">
					<tr>
						<td class="label">
							English Name of Foreign Financial Regulatory Authority
						</td>
						<td>
							<div class="fakeBox3"></div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Foreign Registration No. (if any)
						</td>
						<td>
							<div class="fakeBox3"></div>
						</td>
					</tr>
					<tr>
						<td class="label">
							English Name of Country:
						</td>
						<td>
							<div class="fakeBox3"></div>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
		<div class="information">
			<p>
				If applicant has more than 3 Foreign Financial Regulatory Authorities to report, complete additional Schedule F Page 1s.
			</p>
		</div>
	</xsl:template>
</xsl:stylesheet>