<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-a_tab3">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - Page 3</h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE-A
			</p>
			<p id="pageHeaderDetail">
				Application for Registration as a Security-based Swap Dealer<br/>
				and Major Security-based Swap Participant that is Registered<br/>
				or Registering with the CFTC as a Swap Dealer or Major Swap Participant
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;
				<b><u><xsl:value-of select="p:formData/p:applicant/p:applicantThree/p:applicantName"/></u></b>
				<br/>
				Date:&#160;
				&#160;&#160;
				<em>Applicant</em> NFA No.:&#160;
				<b><u><xsl:value-of select="p:formData/p:applicant/p:applicantThree/p:applicantNFANo"/></u></b>
			</p>
		</div>			
		<h4 class="titleNumber">13.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does the <em>applicant</em> have any arrangement:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					A. With any other <em>person</em>, firm, or organization under which any 
					books or records of the <em>applicant</em> are kept, maintained, or audited 
					by such other <em>person</em>, firm or organization?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isRecordsKept = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isRecordsKept = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					B. Under which such other person, firm or organization executes, trades, 
					custodies, clears or settles on behalf of the applicant (including any SRO 
					in which the applicant is a member)?  
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isOnBehalf = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isOnBehalf = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "yes" to any part of Item 13, complete appropriate items on Schedule B, Section II.</em>
			</p>
		</div>

		<h4 class="titleNumber">14.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does any <em>person</em> directly or indirectly <em>control</em> the 
					management or policies of the <em>applicant</em> through agreement or otherwise?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isControlThroughAgreement = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isControlThroughAgreement = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>		
		
		<div class="information">
			<p>
				<em>If "yes," complete appropriate item on Schedule B, Section II.</em>
			</p>
		</div>
		
		<h4 class="titleNumber">15.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does any <em>person</em> directly or indirectly finance 
					(wholly or partially) the business of the applicant? 
					<em>Do not answer "Yes" to Item 15 if the person finances the 
					business of the applicant through: 1) a public offering of 
					securities made pursuant to the Securities Act of 1933; or 
					2) credit extended in the ordinary course of business by suppliers, banks, and others.</em>
				</td>
				<td>
				<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isWhollyOrPartiallyFinance = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isWhollyOrPartiallyFinance = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		
		<div class="information">
			<p>
				<em>If "yes," complete appropriate item on Schedule B, Section II.</em>
			</p>
		</div>
		
		<h4 class="titleNumber">16.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> at the time of this filing <em>succeeding</em> 
					to the business of a currently registered SBS Entity? 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isSucceeding = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isSucceeding = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "yes," complete appropriate items on Schedule B, Section Ill.</em>
			</p>
		</div>
		
		<h4 class="titleNumber">17.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> registered with a foreign financial regulatory authority?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isForeignRegulatory = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isForeignRegulatory = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>		
		
		<div class="information">
			<p>
				If "<em>yes,</em>" list all such registrations on Schedule F, Page 1, Section II.
			</p>
		</div>
		
		<h4 class="titleNumber">18.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					The applicant has ___ principals who are individuals.
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantThree/p:numberOfPrincipals"/>
					</div>
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>Please list all principals who are individuals on Schedule A.</em>
			</p>
		</div>		
		
		<h4 class="titleNumber">19.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does any principal not identified in Item 18 and Schedule A effect, 
					or is any principal not identified in Item 18 and
					Schedule A involved in effecting security-based swaps on behalf of 
					the applicant, or will such principals effect or be
					involved in effecting such business on the applicant's behalf?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isNotIdentified = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantThree/p:isNotIdentified = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>
		
		<div class="information">
			<p>
				<em>If "yes," complete appropriate item on Schedule B, Section IV.</em>
			</p>
		</div>

	</xsl:template>
</xsl:stylesheet>