<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-a_tab2">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - Page 2</h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE-A
			</p>
			<p id="pageHeaderDetail">
				Application for Registration as a Security-based Swap Dealer<br/>
				and Major Security-based Swap Participant that is Registered<br/>
				or Registering with the CFTC as a Swap Dealer or Major Swap Participant
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;
				<b><u><xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:applicantName"/></u></b>
				<br/>
				Date:&#160;
				&#160;&#160;
				<em>Applicant</em> NFA No.:&#160;
				<b><u><xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:applicantNFANo"/></u></b>
			</p>
		</div>	
		<h4 class="titleNumber">2.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>applicant</em> is registering as a security-based swap dealer:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSwapDealer = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSwapDealer = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			
			<tr>
				<td class="label">
					B. The <em>applicant</em> is registering as a major security-based swap participant:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSwapParticipant = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSwapParticipant = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>			
			
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isSwapParticipant = 'Y'">
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="item2b_1">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:swapOption">
						<xsl:if test="contains(. , 'swap')">
							<xsl:value-of select="string('maintains a substantial security-based swap position')"/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="item2b_2">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:swapOption">
						<xsl:if test="contains(. , 'exposure')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="item2b_3">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:swapOption">
						<xsl:if test="contains(. , 'capital')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>	
				<!-- VARIABLES END -->	
				<tr>
					<td class="label">
						<blockquote>
							Because it: (check all that apply):
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($item2b_1 , 'swap')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;maintains a substantial security-based swap position<br/>
						<xsl:choose>
							<xsl:when test="contains($item2b_2 , 'exposure')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;has substantial counterparty exposure<br/>
						<xsl:choose>
							<xsl:when test="contains($item2b_3 , 'capital')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;is highly leveraged to its capital position	
					</td>
				</tr>
			</xsl:if>
		</table>
		
		<h4 class="titleNumber">3.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Is the <em>applicant</em> a foreign security-based swap dealer that intends to:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<ul>
						<li>
						work with the Commission and its primary regulator to have 
						the Commission determine whether the requirements of its primary 
						regulator's regulatory system are comparable to the Commission's
						</li>
					</ul>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isCommissionDetermine = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isCommissionDetermine = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					<ul>
						<li>
							avail itself of a previously granted substituted compliance determination
						</li>
					</ul>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSelfDetermine = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSelfDetermine = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<tr>
				<td class="label">
					with respect to the requirements of Section 15F of the Exchange 
					Act of 1934 and the rules and regulations thereunder?
				</td>
				<td></td>
			</tr>
			
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isSelfDetermine = 'Y'
					   or p:formData/p:applicant/p:applicantTwo/p:isCommissionDetermine = 'Y'">
				<tr>
					<td class="label">
						B. If <em>"yes"</em> to either of the questions in Item 3.A. above, identify the foreign financial 
						regulatory authority that serves as the <em>applicant</em>'s primary regulator and for which the 
						Commission has made, or may make, a substituted compliance determination:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:foreignFinancialRegulatory"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isSelfDetermine = 'Y'">			
				<tr>
					<td class="label">
						C. If the applicant is relying on a previously granted substituted compliance determination,
						please describe how the <em>applicant</em> satisfies any conditions the Commission may have placed on 
						such substituted compliance determination:
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:description3C"/>
						</div>
					</td>
				</tr>				
			</xsl:if>
		</table>
		
		<h4 class="titleNumber">4.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does the <em>applicant</em> intend to compute capital or margin, or 
					price customer or proprietary positions, using mathematical models?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isMathematicalModels = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isMathematicalModels = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>		
		
		<h4 class="titleNumber">5.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. The <em>applicant</em> is currently registered with 
					the Commodity Futures Trading Commission as a:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:registeredAs, 'Dealer')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Swap Dealer&#160;
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:registeredAs, 'Participant')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Major Swap Participant
				</td>
			</tr>
			<tr>
				<td class="label">
					B. The applicant is registering with the Commodity Futures Trading Commission as a:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:registeringAs, 'Dealer')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Swap Dealer&#160;
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:registeringAs, 'Participant')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Major Swap Participant
				</td>
			</tr>
		</table>		
	
		<h4 class="titleNumber">6.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> a U.S. branch of a non-resident entity?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isNonResidentEntity = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isNonResidentEntity = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isNonResidentEntity = 'Y'">
				<tr>
					<td class="label">
						If <em>"yes,"</em> identify the non-resident entity and its location:
					</td>
					<td></td>
				</tr>
				
				<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:nonResidentEntity">
					<tr>
						<td class="label">
							<blockquote>
								Entity Name:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:entityName"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Street Address 1:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:entityAddress/p1:street1"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Street Address 2:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:entityAddress/p1:street2"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								City:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:entityAddress/p1:city"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								State/Country:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode" select="p:entityAddress/p1:stateOrCountry"/>	
								</xsl:call-template>	
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								Zip + 4 Postal Code:
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:entityAddress/p1:zipCode"/>
							</div>
						</td>
					</tr>	
				</xsl:for-each>
			</xsl:if>			
		</table>	
	
		<h4 class="titleNumber">7. </h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Briefly describe the <em>applicant'</em>s business:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:descriptionBusiness"/>
					</div>
				</td>
			</tr>
		</table>	
	
		<h4 class="titleNumber">8.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> subject to regulation by a prudential 
					regulator, as defined in Section 1a(39) of the Commodity Exchange Act.			
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSubjectToRegulator = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isSubjectToRegulator = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isSubjectToRegulator = 'Y'">
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse-a_item8_first">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:prudentialRegulator">
						<xsl:if test="contains(., 'Reserve Board')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_item8_second">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:prudentialRegulator">
						<xsl:if test="contains(., 'Comptroller of the Currency')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_item8_third">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:prudentialRegulator">
						<xsl:if test="contains(., 'Deposit Insurance Corporation')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_item8_fourth">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:prudentialRegulator">
						<xsl:if test="contains(., 'Credit Administration')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_item8_fifth">
					<xsl:for-each select="p:formData/p:applicant/p:applicantTwo/p:prudentialRegulator">
						<xsl:if test="contains(., 'Finance Agency')">
							<xsl:value-of select="."/>
						</xsl:if>			
					</xsl:for-each>
				</xsl:variable>
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						<blockquote>
							If <em>"yes,"</em> identify the prudential regulator:
						</blockquote>	
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse-a_item8_first , 'Reserve Board')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Reserve Board<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-a_item8_second , 'Comptroller of the Currency')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Office of the Comptroller of the Currency<br/>				
						<xsl:choose>
							<xsl:when test="contains($sbse-a_item8_third , 'Insurance Corporation')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Deposit Insurance Corporation<br/>
						<xsl:choose>
							<xsl:when test="contains($sbse-a_item8_fourth , 'Credit Administration')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Farm Credit Administration<br/>					
						<xsl:choose>
							<xsl:when test="contains($sbse-a_item8_fifth , 'Finance Agency')">
								<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;The Federal Housing Finance Agency
					</td>
				</tr>
			</xsl:if>
		</table>
	
		<h4 class="titleNumber">9.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Is the <em>applicant</em> registered with the Commission as an investment adviser? 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isInvestmentAdvisor = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isInvestmentAdvisor = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isInvestmentAdvisor = 'Y'">
				<tr>
					<td class="label">
						Applicant's IARD #:
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:applicantIardNo"/>
						</div>
					</td>
				</tr>
			</xsl:if>
		</table>	
	
		<h4 class="titleNumber">10.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Is the <em>applicant</em> registered with the Commodity Futures Trading 
					Commission in any capacity other than as a swap dealer or major swap participant?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isRegisteredAsOther = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isRegisteredAsOther = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:isRegisteredAsOther = 'Y'">
				<tr>
					<td class="label">
						B. If "yes," as a:
					</td>
					<td>
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:applicantOtherType, 'Merchant')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures Commission Merchant<br/>
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:applicantOtherType, 'Broker')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Introducing Broker<br/>				
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:applicantOtherType, 'Operator')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Pool Operator<br/>
					<xsl:choose>
						<xsl:when test="contains(p:formData/p:applicant/p:applicantTwo/p:applicantOtherType, 'Other')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other
					</td>
				</tr>
				<xsl:if test="p:formData/p:applicant/p:applicantTwo/p:applicantOtherType = 'Other'">
					<tr>
						<td class="label">
							<blockquote>
								If Other, specify:
							</blockquote>
						</td>
						<td>			
							<div class="fakeBox">
								<xsl:value-of select="p:formData/p:applicant/p:applicantTwo/p:otherSpecify"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
		</table>	
	
		<h4 class="titleNumber">11.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does <em>applicant</em> engage in any other non-securities,
					<em>financial services industry-related</em> business?				
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isEngageInOtherBusiness = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isEngageInOtherBusiness = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		
		<div class="information">
			<p>
				<em>If "yes," describe each other business briefly on Schedule B, Section I.</em>			
			</p>
		</div>
	
		<h4 class="titleNumber">12.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Does the <em>applicant</em> hold or maintain any funds 
					or securities to collateralize counterparty transactions?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isHoldFunds = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:formData/p:applicant/p:applicantTwo/p:isHoldFunds = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
	</xsl:template>
</xsl:stylesheet>