<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
    xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-a_tab1">
		<h1><xsl:value-of select="$submissionType"/>: Applicant Data - Page 1</h1>
		
		<table role="presentation" id="ombHeaderTable">
			<tr>
				<td class="label" style="width:80%;padding:0px 0px 0px 315px;">			
					<div class="pageHeader" style="border:none;">
						<p id="pageHeaderTitle">
							FORM SBSE-A
						</p>
						<p id="pageHeaderDetail">
							Application for Registration as a Security-based <br/>
							Swap Dealer and Major Security-based Swap <br/>
							Participant that is Registered or Registering <br/>
							with the CFTC as a Swap Dealer or Major Swap Participant
						</p>
						<p id="pageHeaderQuestion">
							Date:&#160;
							&#160;&#160;
							<em>Applicant</em> NFA Number:&#160;
							<b><u><xsl:value-of select="$sbse-a_header_common_applicant_nfa"/></u></b>
						</p>
					</div>
				</td>
				<td class="label" style="width:20%;">
					<table role="presentation" id="header">
						<tr>
							<td class="title">OMB APPROVAL</td>
						</tr>	
						<tr>
							<td class="side" >
								<p>OMB Number:&#160;&#160;3235-AL05</p>
								<hr/>
								<p>Estimated average burden hours per response – initial: 34 hours</p>
								<hr/> 
								<p>Estimated average burden hours per response – amendment: 1 hour</p>
								<hr/> 
								<p>Estimated additional average burden hours for Schedule F – initial: 1.5 hours</p>
								<hr/>
								<p>Estimated additional average burden hours per response – amendment: 1.5 hours</p>
							</td>
						</tr>
					</table>					
				</td>
			</tr>
		</table>
			
		<div class="warning">
			<u>WARNING:</u>
			<font style="font-weight:lighter">
				Failure to keep this form current and to file accurate supplementary information on a timely basis, 
				or the failure to keep accurate books and records or otherwise to comply with the provisions of law 
				applying to the conduct of business as an SBS Entity, would violate the Federal securities laws and 
				may result in disciplinary, administrative, injunctive or criminal action.
			</font>
			<br/><br/>		
			<b>INTENTIONAL MISSTATEMENTS OR OMISSIONS OF FACTS MAY CONSTITUTE FEDERAL CRIMINAL VIOLATIONS. </b>
			<br/><br/>
			<font style="font-weight:lighter">
				See 18 U.S.C. 1001 and 15 U.S.C. 78ff(a)
			</font>
		</div>
		
		<h4 class="titleNumber">1. Exact name, principal business address, mailing address, if different, and telephone number of the <em>applicant</em>:</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. Full name of the <em>applicant</em>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:fullApplicantName"/>						
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					B. IRS Empl. Ident. No.:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:irsEmplIdentNo"/>		
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					C. Applicant's NFA ID #: 
				</td>
				<td>
					<div class="fakeBox2">		
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:applicantNFAId"/>			
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Applicant's CIK #:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">		
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:applicantCik"/>			
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Applicant’s UIC # (if any):
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">			
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:applicantUic"/>		
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					D. <em>Applicant</em>'s Main Address: 
					(Do not use a P.O. Box) 
				</td>
				<td></td>
			</tr>			
			<tr>
				<td class="label"><blockquote>Street Address 1:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mainAddress/p1:street1"/>	
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Street Address 2:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mainAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			<tr>
				<td class="label"><blockquote>City:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mainAddress/p1:city"/>
					</div>
				</td>
			</tr>			
			<tr>
				<td class="label"><blockquote>State/Province/Country:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param 
								name="stateCode" 
								select="p:formData/p:applicant/p:applicantOne/p:mainAddress/p1:stateOrCountry"/>
						</xsl:call-template>					
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Zip/ Postal Code:</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mainAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					E. Mailing Address, if different:  
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label"><blockquote>Street Address 1:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mailingAddress/p1:street1"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Street Address 2:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mailingAddress/p1:street2"/>
					</div>
				</td>
			</tr>			
			<tr>
				<td class="label"><blockquote>City:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mailingAddress/p1:city"/>
					</div>
				</td>
			</tr>			
			<tr>
				<td class="label"><blockquote>State/Province/Country:</blockquote></td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param 
								name="stateCode" 
								select="p:formData/p:applicant/p:applicantOne/p:mailingAddress/p1:stateOrCountry"/>
						</xsl:call-template>					
					</div>
				</td>
			</tr>
			<tr>
				<td class="label"><blockquote>Zip/ Postal Code:</blockquote></td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:mailingAddress/p1:zipCode"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					F. Business Telephone Number:
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:businessTelephoneNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					G. Website/URL:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:websiteUrl"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					H. Contact Employee:
				</td>
				<td></td>
			</tr>
				<!-- Optional -->
				<tr>
					<td class="label">
						<blockquote>
							Prefix:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:prefix"/>
						</div>
					</td>
				</tr>
			<tr>
				<td class="label">
					<blockquote>
						First Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:firstName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Middle Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:middleName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Last Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:lastName"/>
					</div>
				</td>
			</tr>
				<!-- Optional -->
				<tr>
					<td class="label">
						<blockquote>
							Suffix:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:contactEmployeeName/p1:suffix"/>
						</div>
					</td>
				</tr>	
			<tr>
				<td class="label">
					<blockquote>
						Title:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:title"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Phone:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:phone"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						Email Address:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:contactEmployee/p:emailAddress"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					I. Chief Compliance Officer designated by the <em>applicant</em> in accordance with Exchange Act Section 15F(k):
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						Prefix:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:prefix"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						First Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:firstName"/>
					</div>
				</td>
			</tr>
				<!-- Optional -->
				<tr>
					<td class="label">
						<blockquote>
							Middle Name:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:middleName"/>
						</div>
					</td>
				</tr>
			<tr>
				<td class="label">
					<blockquote>
						Last Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:lastName"/>
					</div>
				</td>
			</tr>
				<!-- Optional -->
				<tr>
					<td class="label">
						<blockquote>
							Suffix:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:officerName/p1:suffix"/>
						</div>
					</td>
				</tr>	
			<tr>
				<td class="label">
					<blockquote>
						Title:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:title"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Phone:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:phone"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						Email Address:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:formData/p:applicant/p:applicantOne/p:chiefComplianceOfficer/p:emailAddress"/>
					</div>
				</td>
			</tr>			
		</table>
	</xsl:template>
</xsl:stylesheet>