<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-a_tab_scheduleD">
		<xsl:for-each select="p:formData/p:scheduleD/p:scheduleDList">
			<h1><xsl:value-of select="$submissionType"/>: Schedule D of Form SBSE-A Page 1</h1>
			<div class="pageHeader">
				<p id="pageHeaderTitle">
					FORM SBSE-A
				</p>
				<p id="pageHeaderDetail">
					Application for Registration as a Security-based Swap Dealer<br/>
					and Major Security-based Swap Participant that is Registered<br/>
					or Registering with the CFTC as a Swap Dealer or Major Swap Participant
				</p>
				<p id="pageHeaderQuestion">
					<em>Applicant</em> Name:&#160;
					<b><u><xsl:value-of select="p:applicantName"/></u></b>
				</p>
				<p id="pageHeaderQuestion">
					<em>Principal</em> Name:&#160;
					<b><u><xsl:value-of select="p:principalName"/></u></b>
				</p>			
				<p id="pageHeaderQuestion">
					Date:&#160;
					&#160;&#160;
					<em>Applicant</em> NFA Number:&#160;
					<b><u><xsl:value-of select="$sbse-a_header_common_applicant_nfa"/></u></b>
				</p>
			</div>	
			<xsl:call-template name="sbse-a_scheduleD_page1"/>
			<h1><xsl:value-of select="$submissionType"/>: Schedule D of Form SBSE-A Page 2</h1>
			<div class="pageHeader">
				<p id="pageHeaderTitle">
					FORM SBSE-A
				</p>
				<p id="pageHeaderDetail">
					Application for Registration as a Security-based Swap Dealer<br/>
					and Major Security-based Swap Participant that is Registered<br/>
					or Registering with the CFTC as a Swap Dealer or Major Swap Participant
				</p>
				<p id="pageHeaderQuestion">
					<em>Applicant</em> Name:&#160;
					<b><u><xsl:value-of select="p:applicantName"/></u></b>
				</p>
				<p id="pageHeaderQuestion">
					<em>Principal</em> Name:&#160;
					<b><u><xsl:value-of select="p:principalName"/></u></b>
				</p>			
				<p id="pageHeaderQuestion">
					Date:&#160;
					&#160;&#160;
					<em>Applicant</em> NFA Number:&#160;
					<b><u><xsl:value-of select="$sbse-a_header_common_applicant_nfa"/></u></b>
				</p>
			</div>	
			<xsl:call-template name="sbse-a_scheduleD_page2"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="sbse-a_scheduleD_page1">
		<div class="information">
			<p>
				Use the appropriate DRP for providing details to "yes" answers to the questions in Schedule D. Refer to the
				Explanation of Terms section of Form SBSE-A Instructions for explanations of italicized terms.
			</p>
		</div>
		<h4 class="titleNumber">CRIMINAL DISCLOSURE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. In the past ten years has the <em>principal</em>:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1) Been convicted of or pled guilty or nolo contendere ("no contest")
						in a domestic, foreign or military court to any felony?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isConvictedOfFelony = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isConvictedOfFelony = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(2) Been charged with a felony
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isChargedWithFelony = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isChargedWithFelony = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					B. In the past ten years has the principal:
				</td>
				<td></td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						(1) Been convicted of or pled guilty or or nolo contendere ("no contest") 
						in a domestic, foreign or military court to a misdemeanor involving: financial 
						services industry-related business, or any fraud, false statements or omissions, 
						wrongful taking of property, bribery, perjury, forgery, counterfeiting,
						extortion, or a conspiracy to commit any of these offenses?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isConvictedMisdemeanor = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isConvictedMisdemeanor = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>			
			<tr>
				<td class="label">
					<blockquote>
						(2)Been charged with a <em>misdemeanor</em> specified in B(1)?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isChargedMisdemeanor = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:criminalDisclosure/p:isChargedMisdemeanor = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>										
		</table>
		<h4 class="titleNumber">REGULATORY ACTION DISCLOSURE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					C. Has the U.S. Securities and Exchange Commission or the Commodity Futures Trading Commission ever:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1) <em>Found</em> the <em>principal</em> to have made a false statement or omission? 
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isMadeFalseStatement = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes 
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isMadeFalseStatement = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(2) <em>Found</em> the <em>principal</em> to have been involved in a violation of its regulations or statutes?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isViolatedRegulation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isViolatedRegulation = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(3) <em>Found</em> the <em>principal</em> to have been a cause of a <em>financial 
						services industry-related business</em> having its authorization to do business denied, 
						revoked, or restricted?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isCauseOfDenial = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isCauseOfDenial = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(4) Entered an <em>order</em> against the <em>principal</em> in connection with
						<em>financial services industry-related</em> activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isOrderAgainst = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes 
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isOrderAgainst = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(5) Imposed a civil money penalty on the <em>principal</em>, or ordered the <em>principal</em> to cease and desist from any activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isImposedPenalty = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isImposedPenalty = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					D. Has any other federal regulatory agency, state regulatory agency, or <em>foreign financial regulatory authority</em>:
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(1)  Ever found the <em>principal</em> to have made a false statement or omission or been dishonest, unfair, or unethical?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isUnethical = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isUnethical = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(2) Ever found the <em>principal</em> to have been involved in a violation of <em>financial services industry-related</em> regulations or statutes?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInViolationOfRegulation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInViolationOfRegulation = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(3) Ever found the <em>principal</em> to have been a cause of a <em>financial services industry-related</em> 
						business having its authorization to do business denied, suspended, revoked or restricted?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInCauseOfDenial = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes 
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInCauseOfDenial = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(4) In the past ten years, entered an order against the <em>principal</em> in connection with a <em>financial services industry-related</em> activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isOrderAgainstActivity = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isOrderAgainstActivity = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(5) Ever denied, suspended, or revoked the <em>principal</em>'s registration or license or otherwise, 
						by order, prevented it from associating with a <em>financial services industry-related business</em>
						or restricted its activities?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isDeniedLicense = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isDeniedLicense = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>	
			<tr>
				<td class="label">
					E. Has any <em>self-regulatory organization</em> or commodities exchange ever:
				</td>
				<td></td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(1) <em>found</em> the <em>principal</em> to have made a false statement or omission?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundMadeFalseStatement = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundMadeFalseStatement = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(2) <em>found</em> the <em>principal</em> to have been involved in a violation of its rules
						 (other than a violation designated as a <em>"minor rule violation"</em> under a 
						 plan approved by the U.S. Securities and exchange Commission)?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInViolationOfRules = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInViolationOfRules = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(3) <em>found</em> the <em>principal</em> to have been the cause of a <em>financial services industry-related</em> 
						business having its authorization to do business denied, suspended, revoked or restricted?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInCauseOfSuspension = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isFoundInCauseOfSuspension = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
						(4) Disciplined the <em>principal</em> by expelling or suspending it from membership, barring or suspending its
						association with other members, or otherwise restricting its activities?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isDisciplined = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isDisciplined = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					F.  Has the <em>principal's</em> authorization to act as an attorney, accountant, or federal contractor ever been
					revoked or suspended?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isAuthorizedToActAttorney = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isAuthorizedToActAttorney = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					G. Is the <em>principal</em> now the subject of any regulatory proceeding that could result in a 
					"yes" answer to any part of C, D, or E?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isNamedInRegulatoryProceeding = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:regulatoryActionDisclosure/p:isNamedInRegulatoryProceeding = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>																																
		</table>
	</xsl:template>
	
	<xsl:template name="sbse-a_scheduleD_page2">
		<h4 class="titleNumber">CIVIL JUDICIAL DISCLOSURE</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					H.  (1)  Has any domestic or foreign civil judicial court:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(a) In the past ten years, enjoined the <em>principal in connection with any financial services
						industry-related</em> activity?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isEnjoined = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isEnjoined = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(b)  Ever <em>found</em> that the <em>principal</em> was involved in a violation 
						of <em>financial services industry-related</em> statutes or regulations?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isFoundInViolationOfRegulation = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isFoundInViolationOfRegulation = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						(c) Ever dismissed, pursuant to a settlement agreement, a <em>financial services industry-related</em>
						civil judicial action brought against the principal by a state or <em>foreign financial regulatory authority</em>?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isDismissed = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isDismissed = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>										
			<tr>
				<td class="label">
					(2) Is the <em>principal</em> now the subject of any civil judicial proceeding that could result in a "yes" answer
					to any part of H(1)?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isNamedInCivilProceeding = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:civilJudicialActionDisclosure/p:isNamedInCivilProceeding = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>	
		</table>	
		<h4 class="titleNumber">FINANCIAL DISCLOSURE</h4>	
		<table role="presentation">
			<tr>
				<td class="label">
					I. In the past ten years has the <em>principal</em> ever been a securities firm or a <em>principal</em> of a securities firm that:
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(1) Has been the subject of a bankruptcy petition?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:financialDisclosure/p:hasSubjectOfBankruptcy = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:financialDisclosure/p:hasSubjectOfBankruptcy = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(2) Has had a trustee appointed or a direct payment procedure initiated under the Securities
						Investor Protection Act?
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:financialDisclosure/p:hasTrusteeAppointed = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:financialDisclosure/p:hasTrusteeAppointed = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No					
				</td>
			</tr>
		</table>			
	</xsl:template>
</xsl:stylesheet>