<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-a_tab_scheduleB">
		<h1><xsl:value-of select="$submissionType"/>: Schedule B of FORM SBSE-A</h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE-A
			</p>
			<p id="pageHeaderDetail">
				Application for Registration as a Security-based Swap Dealer<br/>
				and Major Security-based Swap Participant that is Registered<br/>
				or Registering with the CFTC as a Swap Dealer or Major Swap Participant
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;
				<b><u><xsl:value-of select="p:formData/p:scheduleB/p:applicantName"/></u></b>
				<br/>
				Date:&#160;
				&#160;&#160;
				<em>Applicant</em> NFA No.:&#160;
				<b><u><xsl:value-of select="p:formData/p:scheduleB/p:applicantNFANo"/></u></b>
			</p>
		</div>				
		<div class="information">		
			<p>
				Use this Schedule B to report details for items listed below. Report only new information or changes/updates to
				previously submitted details. Do not repeat previously submitted information.
			</p>
		</div>
		<table role="presentation">
			<tr>
				<td class="label">
					This is an INITIAL / AMENDED detail filing for the Form SBSE-A items checked below:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:formData/p:scheduleB/p:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Initial&#160;&#160;
					<xsl:choose>
						<xsl:when test="p:formData/p:scheduleB/p:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Amended
				</td>
			</tr>
		</table>
		
		<xsl:if test="count(p:formData/p:scheduleB/p:sectionOne) &gt; 0">
			<div id="twoHeaders">
				<h4 class="title1">Section I</h4>
				<h4 class="title2"><em>Other Business</em></h4>
			</div>
			<div class="informationNoBorder">
				<h4 class="title3">Item 11: Does <em>applicant engage in any other 
								non-securities, financial services industry-related business?</em></h4>
			</div>
			<xsl:for-each select="p:formData/p:scheduleB/p:sectionOne">
				<table role="presentation">
					<tr>
						<td class="label">
							<em>UIC (if any), or other Unique Identification Number(s):</em>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:uicNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<em>Assigning Regulator(s)/Entity(s):</em>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:assigningRegulators"/>
							</div>
						</td>
					</tr>			
					<tr>
						<td class="label">
							<em>Briefly describe any other financial services industry-related, 
							non-securities business in which the applicant is engaged:</em>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:description"/>
							</div>
						</td>
					</tr>
				</table>
			</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="count(p:formData/p:scheduleB/p:sectionTwo) &gt; 0">
			<div id="twoHeaders">
				<h4 class="title1">Section II</h4> 
				<h4 class="title2"><em>Record Maintenance Arrangements I Business Arrangements I Control Persons I Financings</em></h4>
			</div>
			<xsl:for-each select="p:formData/p:scheduleB/p:sectionTwo/p:recordsKeptDetails/p:recordsKept">
				<xsl:call-template name="sbse-a_scheduleB_sectionTwo" />
			</xsl:for-each>
			<xsl:for-each select="p:formData/p:scheduleB/p:sectionTwo/p:onBehalfDetails/p:onBehalf">
				<xsl:call-template name="sbse-a_scheduleB_sectionTwo" />
			</xsl:for-each>
			<xsl:for-each select="p:formData/p:scheduleB/p:sectionTwo/p:controlThroughAgreementDetails/p:controlThroughAgreement">
				<xsl:call-template name="sbse-a_scheduleB_sectionTwo" />
			</xsl:for-each>
			<xsl:for-each select="p:formData/p:scheduleB/p:sectionTwo/p:whollyOrPartiallyFinanceDetails/p:whollyOrPartiallyFinance">
				<xsl:call-template name="sbse-a_scheduleB_sectionTwo" />
			</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="p:formData/p:applicant/p:applicantThree/p:isSucceeding = 'Y'">
			<div id="twoHeaders">
				<h4 class="title1">Section III</h4> 
				<h4 class="title2"><em>Successions</em></h4>
			</div>
			<div class="informationNoBorder">
				<h4 class="title3">Item 16: Is the <em>applicant</em> at the time of this filing <em>succeeding</em> to the business of a currently registered SBS Entity?</h4>
			</div>
			<table role="presentation">
				<tr>
					<td class="label">
						<em>Date of Succession</em> MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:dateOfSuccession"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<em>Name of Predecessor</em>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:nameOfPredecessor"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						SEC File, CRD, NFA, lARD, UIC, and/or CIK Number (if any) 
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							SEC File Number (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:secFileNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							CRD (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:crdNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							NFA (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:nfa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							IARD (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:iardNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							UIC Number (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:uicNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							CIK Number (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:cikNumber"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							IRS Employer Number (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:irsEmployerNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Briefly describe details of the succession including any assets or liabilities not assumed by the successor. 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:formData/p:scheduleB/p:sectionThree/p:descriptionSuccession"/>
						</div>
					</td>
				</tr>			
			</table>
		</xsl:if>
		
		<xsl:if test="p:formData/p:applicant/p:applicantThree/p:isNotIdentified = 'Y'">
			<div id="twoHeaders">
				<h4 class="title1">Section IV</h4> 
				<h4 class="title2"><em>Principals Effecting or Involved in Effecting SBS Business</em></h4>
			</div>
			<div class="informationNoBorder">
				<h4 class="title3" style="line-height:1;">Item 19: Does any principal not identified in Item 18 and Schedule A effect, or is any principal not identified in Item 15
					and Schedule A involved in effecting security-based swaps on behalf of the applicant, or will such principals effect or
					be involved in effecting such business on the applicant's behalf?
					<br/><br/>
					<em>For each Principal identified in Section IV, complete Schedule D of the Form SBSE-A and the relevant DRP pages.</em>
				</h4>
			</div>
			<xsl:for-each select="p:formData/p:scheduleB/p:sectionFour">
				<table role="presentation">
					<tr>
						<td class="label">
							Name of Principal
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:nameOfPrincipal"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							Type of Entity
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p:typeOfEntity, 'Corporation')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Corporation&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:typeOfEntity, 'Partnership')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Partnership&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:typeOfEntity, 'Limited')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Liability Company&#160;&#160;
							<xsl:choose>
								<xsl:when test="contains(p:typeOfEntity, 'Other')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;Other										
						</td>
					</tr>
					<xsl:if test="contains(p:typeOfEntity, 'Other')">
						<tr>
							<td class="label">
								<blockquote>
									If Other, please describe
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p:otherSpecify"/>
								</div>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td class="label">
							SEC File No., CRD, NFA, IARD, CIK Number, UIC(if any), and/or Tax Identification Number 
						</td>
						<td></td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								SEC File No.
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:secFileNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								CRD
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:crdNo"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								NFA
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:nfa"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								IARD
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:iardNo"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								CIK Number
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:uicNumber"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								UIC (if any)
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:cikNumber"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							<blockquote>
								Tax Identification Number
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:taxIdentificationNumber"/>
							</div>
						</td>
					</tr>	
					<tr>
						<td class="label">
							Business Address <em>(Street, City, State/Country, Zip + 4/Postal Code)</em>
						</td>
						<td></td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Street Address 1
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:address/p1:street1"/>
							</div>
						</td>
					</tr>			
					<tr>
						<td class="label">
							<blockquote>
								Street Address 2
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:address/p1:street2"/>
							</div>
						</td>
					</tr>		
					<tr>
						<td class="label">
							<blockquote>
								City
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:value-of select="p:address/p1:city"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								State/Country
							</blockquote>
						</td>
						<td>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param 
										name="stateCode" 
										select="p:address/p1:stateOrCountry"/>
								</xsl:call-template>																
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							<blockquote>
								Zip + 4/ Postal Code
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select="p:address/p1:zipCode"/>
							</div>
						</td>
					</tr>
					<tr>
						<td class="label">
							This entity __________ security based swaps on behalf of the applicant. <em>(check only one)</em>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p:effectType, 'effects')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;[ ] effects<br/>
							<xsl:choose>
								<xsl:when test="contains(p:effectType, 'involved')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;[ ] is involved in effecting					
						</td>
					</tr>	
					<tr>
						<td class="label">
							Briefly describe the details of the principal's activities relating to its 
							effecting or involvement in effecting security-based swap transactions on behalf of the applicant:
		
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p:description"/>
							</div>
						</td>
					</tr>				
				</table>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="sbse-a_scheduleB_sectionTwo">
		<table role="presentation">
			<tr>
				<td class="label">
					<em>(Check  one)</em>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '13A')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 13A&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '13B')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 13B&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '14')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 14&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p:responseType, '15')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Item 15				
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Applicant must complete a separate Schedule B Page 1 for each affirmative response in this section including any
				multiple responses to any item. Complete the "Effective Date" box with the Month, Day and Year that the arrangement
				or agreement became effective. When reporting a change or termination of an arrangement, enter the effective date
				of the change.			
			</p>
		</div>
		<table role="presentation">
			<tr>
				<xsl:if test="p:firmOrIndividual ='Firm' or p:firmOrIndividual ='Individual' ">
					<td class="label">
						Firm or Individual?
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:firmOrIndividual = 'Firm'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Firm&#160;&#160;
						<xsl:choose>
							<xsl:when test="p:firmOrIndividual = 'Individual'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Individual	
					</td>
				</xsl:if>
			</tr>
			<xsl:if test="p:firmOrOrganizationName !=''">
				<tr>
					<td class="label">
						Firm or Organization Name
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:firmOrOrganizationName"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						SEC File, CRD, NFA, lARD, UIC, and/or CIK Number (if any) 
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							SEC File Number (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmSecFileNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							CRD (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmCrdNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							NFA (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmNfa"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							IARD (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmIardNo"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							UIC (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmUic"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							CIK Number (if any)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmCikNumber"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Business Address (<em>Street, City, State/Country, Zip + 4 Postal Code</em>)
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Street Address 1
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmAddress/p1:street1"/>
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>
							Street Address 2
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmAddress/p1:street2"/>
						</div>
					</td>
				</tr>		
				<tr>
					<td class="label">
						<blockquote>
							City
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:firmAddress/p1:city"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							State/Country
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param 
									name="stateCode" 
									select="p:firmAddress/p1:stateOrCountry"/>
							</xsl:call-template>											
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Zip + 4 Postal Code
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmAddress/p1:zipCode"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Effective Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmEffectiveDate"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Termination Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:firmTerminationDate"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<xsl:if test="p:individualName/p1:lastName !=''">
				<tr>
					<td class="label">
						Individual Name
					</td>
					<td></td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							Prefix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualName/p1:prefix"/>
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>
							First Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualName/p1:firstName"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							Middle Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualName/p1:middleName"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							Last Name
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualName/p1:lastName"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							Suffix
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualName/p1:suffix"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						CRD, NFA, and/or IARD Number (if any)
					</td>
					<td></td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							CRD Number 
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualCrdNo"/>
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>
							NFA Number
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualNfa"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							IARD Number
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualIardNo"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Business Address(if applicable) 
						(<em>Street, City, State/Country, Zip + 4 Postal Code</em>)
					</td>
					<td></td>
				</tr>		
				<tr>
					<td class="label">
						<blockquote>
							Street Address 1
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualAddress/p1:street1"/>
						</div>
					</td>
				</tr>			
				<tr>
					<td class="label">
						<blockquote>
							Street Address 2
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualAddress/p1:street2"/>
						</div>
					</td>
				</tr>		
				<tr>
					<td class="label">
						<blockquote>
							City
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p:individualAddress/p1:city"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							State/Country
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:call-template name="stateDescription">
								<xsl:with-param 
									name="stateCode" 
									select="p:individualAddress/p1:stateOrCountry"/>
							</xsl:call-template>					
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
							Zip + 4 Postal Code
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualAddress/p1:zipCode"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						Effective Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualEffectiveDate"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						Termination Date MM DD YYYY
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p:individualTerminationDate"/>
						</div>
					</td>
				</tr>
			</xsl:if>	
			<tr>
				<td class="label">
					Briefly describe the nature of the arrangement with respect to 
					books or records (ITEM 13A); the nature of the execution, trading, 
					custody, clearing or settlement arrangement (ITEM 13B); the nature 
					of the control or agreement (ITEM 14); or the method and amount of financing (ITEM 15). 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:descriptionArrangement"/>
					</div>
				</td>
			</tr>
			<xsl:if test="contains(p:responseType, '14') and count(p:descriptionExperience) &gt; 0">	
				<tr>
					<td class="label">
						For ITEM 14 ONLY - If the control person is an individual not 
						presently registered through CRD or lARD, describe prior investment-related 
						experience (e.g., for each prior position-employer, job title, and dates of service).
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p:descriptionExperience"/>
						</div>
					</td>
				</tr>				
			</xsl:if>
		</table>
	</xsl:template>
</xsl:stylesheet>