<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common">

	<xsl:template name="sbse-a_tab_scheduleA">
		<h1><xsl:value-of select="$submissionType"/>: Schedule A of FORM SBSE-A</h1>
		<div class="pageHeader">
			<p id="pageHeaderTitle">
				FORM SBSE-A
			</p>
			<p id="pageHeaderDetail">
				Application for Registration as a Security-based Swap Dealer<br/>
				and Major Security-based Swap Participant that is Registered<br/>
				or Registering with the CFTC as a Swap Dealer or Major Swap Participant
			</p>
			<p id="pageHeaderQuestion">
				<em>Applicant</em> Name:&#160;
				<b><u><xsl:value-of select="$sbse-a_header_common_applicant_name"/></u></b>
				<br/>
				Date:&#160;
				&#160;&#160;
				<em>Applicant</em> NFA No.:&#160;
				<b><u><xsl:value-of select="$sbse-a_header_common_applicant_nfa"/></u></b>
			</p>
		</div>	
		<h4 class="title1">PRINCIPALS THAT ARE INDIVIDUALS (Answer for Form SBSE-A Item 18)</h4>
		<div class="information">	
			<p>
				Use Schedule A to identify all principals of the applicant who are individuals.
				<br/><br/>
				Complete the "Title or Status" column by entering board/management titles; 
				status as partner, trustee, sole proprietor, or shareholder; and for shareholders, 
				the class of securities owned (if more than one is issued).
				<br/><br/>
				Ownership Codes are:
				<br/>	
				<blockquote>NA  - less than 5%
					<br/>
					A  - 5% but less than 10%
					<br/>
					B   - 10% but less than 25%
					<br/>
					C   - 25% but less than 50%
					<br/>
					D   - 50% but less than 75%
					<br/>
					E   - 75% or more
				</blockquote>
			</p>
		</div>				
		<xsl:for-each select="p:formData/p:scheduleA/p:scheduleAInfo">
			<xsl:call-template name="sbse-a_scheduleA"/>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="sbse-a_scheduleA">
		<h4 class="titleNumber">FULL LEGAL NAME</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					Prefix
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:individualName/p1:prefix"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					Individuals: Last Name
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:individualName/p1:lastName"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					Individuals: First Name
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:individualName/p1:firstName"/>
					</div>
				</td>
			</tr>
			
			<tr>
				<td class="label">
					Individuals: Middle Name
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:individualName/p1:middleName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Suffix
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:individualName/p1:suffix"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Title or Status
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p:titleOrStatus"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Date Title or Status Acquired(MM/YYYY)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:dateTitleOrStatusAcquired"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Date Individual began working for applicant (MM/YYYY)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:dateBeganWorking"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					Does person have an ownership interest in the applicant
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p:haveOwnershipInterest = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p:haveOwnershipInterest = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p:haveOwnershipInterest = 'Y'">
				<tr>
					<td class="label">
						<blockquote>
							If yes, include ownership code
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'NA'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;NA  -	less than 5%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'A'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;A  -	5% but less than 10%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'B'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;B   -	10% but less than 25%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'C'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;C   -	25% but less than 50% <br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'D'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;D   -	50% but less than 75%<br/>
						<xsl:choose>
							<xsl:when test="p:ownershipCode =  'E'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;E   -	75% or more
					</td>
				</tr>
			</xsl:if>
		</table>
		<h4 class="titleNumber">NFA Identification No., CRD No. and/or IARD No.</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					NFA Identification No.
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:nfaIdentificationNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					CRD No.
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:crdNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					IARD No.
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p:iardNo"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					For individuals not presently registered through NFA, 
					CRD or lARD, describe prior investment-related experience 
					(e.g., for each prior position- employer, job title, and dates of service):
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p:description"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>