<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p4="http://www.sec.gov/edgar/sbse_a_drp">

	<!-- Parents template -->
	<xsl:template name="sbse-a_tab_drp4_bankruptcySipc">
		<xsl:if test="count(p:formData/p:bankruptcySipcDrpInfo/p4:bankruptcyDrp) &gt; 0">
			<h1>BANKRUPTCY /  SIPC DISCLOSURE REPORTING PAGE (SBSE-A)</h1>
			<h4 class="title1" style="font-style:italic">GENERAL INSTRUCTIONS</h4>
			<div class="information">
				<p>
					You must provide a valid response to each question on every section of this DRP before 
					any of your information can be saved. Invalid or incomplete responses will prevent you 
					from closing the DRP with your information saved. It is recommended that you consult 
					the Print Form of this DRP to make sure you have gathered all the required information 
					before beginning your entry of information online.			
				</p>			
			</div>
				
			<xsl:call-template name="sbse-a_drp4_bankruptcySipc"/>
		</xsl:if>
	</xsl:template>
	
	<!--Child templates for SBSE-A -->
	<xsl:template name="sbse-a_drp4_bankruptcySipc">
		<xsl:for-each select="p:formData/p:bankruptcySipcDrpInfo/p4:bankruptcyDrp">
			<xsl:call-template name="sbse-a_drp4_general"/>
			<xsl:call-template name="sbse-a_drp4_part1"/>
			
			<xsl:if test="p4:BankruptcySipcDrpPartOne/p4:isSubmittedToCRD = 'N'">
				<xsl:call-template name="sbse-a_drp4_part2"/>
			</xsl:if>
		</xsl:for-each>		
	</xsl:template>
	<xsl:template name="sbse-a_drp4_general">
		<table role="presentation">
			<tr>
				<td class="label">
					This Disclosure Reporting Page [DRP (SBSE-A)] is an an [ ] INITIAL <b><em>OR</em></b> 
					[ ] AMENDED response to report details for affirmative responses to <b><em>Questions I</em></b> on Form SBSE; 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p4:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED			
				</td>
			</tr>
			<tr>
				<td class="label">
					Check item(s) being responded to:
				</td>
				<td></td>
			</tr>
			<xsl:variable name="sbse-a_drp_i_1">
				<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
					<xsl:if test="contains(. , '(1)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp_i_2">
				<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
					<xsl:if test="contains(. , '(2)')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<tr>
				<td class="label">
					<blockquote>
						I In the past ten years has the <em>principal</em> ever been 
						a securities firm or a <em>control affiliate</em> of a securities firm that:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp_i_1 , '(1)')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) has been the subject of a bankruptcy petition?<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp_i_2 , '(2)')">
							<img src="Images/box-checked.jpg"   alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) has had a trustee appointed or a direct payment 
					procedure initiated under the Securities Investor Protection Act								
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Use a separate DRP for each event or <em>proceeding</em>. An event or <em>proceeding</em> 
				may be reported for more than one person or entity using one DRP. File with a completed Execution Page.
				<br/><br/>			
				It is not a requirement that documents be provided for each event or <em>proceeding</em>. 
				Should they be provided, they will not be accepted as disclosure in lieu of answering the questions on this DRP.
				<br/><br/>			
				If a <em>principal</em> is an individual or organization registered through CRD, such 
				<em>principal</em> need only complete Part I of the applicant's appropriate DRP (SBSE-A). 
				Details of the event must be submitted on the <em>principal</em>'s appropriate DRP (BD) or 
				DRP (U-4). If a <em>principal</em> is an organization not registered through the CRD, provide 
				complete answers to all the items on the applicant's appropriate DRP (SBSE-A). The completion 
				of this DRP does <u>not</u> relieve the <em>principal</em> of its obligation to update its CRD records.		
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse-a_drp4_part1">
		<h4 class="title1">PART I</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. If the <em>principal</em> is registered with the CRD, provide the CRD number. 
					If not, indicate "non-registered" by checking the appropriate checkbox.

				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					Name of <em>Principal</em>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartOne/p4:nameOfPrincipal"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					CRD NUMBER
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p4:BankruptcySipcDrpPartOne/p4:crdNumber"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					Is the principal registered
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartOne/p4:isRegistered = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartOne/p4:isRegistered = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						<blockquote>
							Is this DRP an amendment that seeks to remove a previously filed DRP concerning the applicant from the record?
						</blockquote> 
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p4:BankruptcySipcDrpPartOne/p4:isShouldBeRemoved = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p4:BankruptcySipcDrpPartOne/p4:isShouldBeRemoved = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No	
					</td>
				</tr>
				<xsl:if test="p4:BankruptcySipcDrpPartOne/p4:isShouldBeRemoved = 'Y'">
					<tr>
						<td class="label">
							<blockquote>
							<blockquote>
								If "yes," the reason the DRP should be removed is:
							</blockquote>
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p4:BankruptcySipcDrpPartOne/p4:drpRemovalReason , 'is no longer')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The principal is no longer associated with the SBS Entity.<br/>
							<xsl:choose>
								<xsl:when test="contains(p4:BankruptcySipcDrpPartOne/p4:drpRemovalReason , 'was resolved in')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or <EM>proceeding</EM> previously reported was resolved in the principal's favor.<br/>
							<xsl:choose>
								<xsl:when test="contains(p4:BankruptcySipcDrpPartOne/p4:drpRemovalReason , 'proceeding occurred')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p4:BankruptcySipcDrpPartOne/p4:drpRemovalReason , 'filed in error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error. 
						</td>
					</tr>
					<xsl:if test="contains(p4:BankruptcySipcDrpPartOne/p4:drpRemovalReason , 'filed in error')">
						<tr>
							<td class="label">
								<blockquote>
									<blockquote>
										<blockquote>
											Explain the circumstances:
										</blockquote>
									</blockquote>
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p4:BankruptcySipcDrpPartOne/p4:explainCircumstances"/>
								</div>
							</td>
						</tr>
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					B. If the <em>principal</em> is registered through the CRD, has the <em>principal</em> 
					submitted a DRP (with Form U-4) or DRP (BD) to the CRD System for the event?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartOne/p4:isSubmittedToCRD = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartOne/p4:isSubmittedToCRD = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				If the answer is "Yes," no other information on this DRP must be provided: If "No," complete Part II.
				<br/>
				<b>Note:</b> The completion of this Form does <u>not</u> relieve the 
				<em>control affiliate</em> of its obligation to update 
				its CRD records.			
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse-a_drp4_part2">
		<h4 class="title1">PART II</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					1. Action Type: (check appropriate item) 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Bankruptcy')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Bankruptcy<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Declaration')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Declaration<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Receivership')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Receivership<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Compromise')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Compromise<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Liquidated')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Liquidated<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Other')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other
				</td>
			</tr>
			<xsl:if test="contains(p4:BankruptcySipcDrpPartTwo/p4:actionType, 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please specify:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:actionTypeOtherDesc"/>
						</div>
					</td>
				</tr>	
			</xsl:if>
			<tr>
				<td class="label">
					2. Action Date (MM/DD/YYYY) 
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:actionDate/p1:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Specify if Action Date is Exact or needs an Explanation
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:actionDate/p1:exactOrExplanation='Exact'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Exact&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:actionDate/p1:exactOrExplanation='Explanation'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Explanation				
				</td>
			</tr>	
			<xsl:if test="not(p4:BankruptcySipcDrpPartTwo/p4:actionDate/p1:exactOrExplanation='Exact')">
				<tr>
					<td class="label">
						<blockquote>
							If not exact, provide explanation:
						</blockquote> 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:actionDate/p1:explanationInfo"/>
						</div>
					</td>
				</tr>	
			</xsl:if>
			<tr>
				<td class="label">
					3.  If the financial action relates to an organization over which the <em>applicant</em> or <em>control affiliate</em> 
					exercise(d) <em>control</em>, enter organization name and the applicant's or control affiliate's position, title or relationship:
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					Organization Name:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:organizationName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					<em>Applicant'</em>s or <em>control affiliate'</em>s Position, title, or Relationship:
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:personDetail"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					Was the Organization investment-related?
					</blockquote> 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:isInvestmentRelated='Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:isInvestmentRelated='N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>	
			<tr>
				<td class="label">
					4. Court action brought in (Name of Federal, State or Foreign Court), Location of Court (City or County
					 <u>and</u> State or Country), Docket/Case Number and Bankruptcy Chapter Number (if Federal Bankruptcy Filing): 
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					Type of Court
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:typeOfCourt='Federal'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Federal&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:typeOfCourt='State'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;State&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:typeOfCourt='Foreign'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign																
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						Name of Federal, State or Foreign Court
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:nameOfCourt"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					Location of Court:
					</blockquote>
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							City or County
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:cityOrCounty"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							State/Country
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox">
						<xsl:call-template name="stateDescription">
							<xsl:with-param name="stateCode" 
									select="p4:BankruptcySipcDrpPartTwo/p4:stateOrCountry"/>
						</xsl:call-template>						
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<blockquote>
							Docket/Case Number
						</blockquote>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:docketOrCaseNo"/>
					</div>
				</td>
			</tr>
			<xsl:if test="p4:BankruptcySipcDrpPartTwo/p4:typeOfCourt='Federal'">
				<tr>
					<td class="label">
						<blockquote>
								Bankruptcy Chapter Number (if Federal Bankruptcy Filing)
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:bankruptcyChapterNo"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<tr>
				<td class="label">
					5. Is action currently pending? 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:isActionPending='Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:isActionPending='N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="p4:BankruptcySipcDrpPartTwo/p4:isActionPending='N'">
				<tr>
					<td class="label">
						6. If not pending, provide Disposition Type: (check appropriate item) 
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Direct')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Direct Payment Procedure<br/>
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Discharged')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Discharged<br/>				
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Dismissed')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dismissed<br/>	
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Dissolved')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dissolved<br/>	
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Satisfied')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Satisfied/Released<br/>	
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'SIPA')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;SIPA Trustee Appointed<br/>		
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Other')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Other			
					</td>
				</tr>	
				<xsl:if test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionType,'Other')">
					<tr>
						<td class="label">
							<blockquote>
								If you selected "Other", please specify
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:dispositionTypeOtherDesc"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						7. Disposition Date (MM/DD/YYYY): 
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:dispositionDate/p1:date"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
						Specify if Disposition Date is Exact or needs an Explanation
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionDate/p1:exactOrExplanation,'Exact')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact
						<xsl:choose>
							<xsl:when test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionDate/p1:exactOrExplanation,'Explanation')">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation				
					</td>
				</tr>	
				<xsl:if test="contains(p4:BankruptcySipcDrpPartTwo/p4:dispositionDate/p1:exactOrExplanation,'Explanation')">
					<tr>
						<td class="label">
							<blockquote>
							<blockquote>
								If not exact, provide explanation:
							</blockquote>
							</blockquote> 
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:dispositionDate/p1:explanationInfo"/>
							</div>
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					8. Provide a brief summary of events leading to the action and if not discharged, explain. (The information must fit within the space provided.): 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:summaryOfEvents"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					9. If a SIPA trustee was appointed or a direct payment procedure was begun, enter the amount paid or agreed to be paid by you; or the name of the trustee: 
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					Name of Trustee
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:nameOfTrustee"/>
					</div>
				</td>
			</tr>		
			<tr>
				<td class="label">
					<blockquote>
					Enter the amount paid or agreed to be paid by you
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select='format-number(p4:BankruptcySipcDrpPartTwo/p4:amountPaid, "$###,###,###,##0.00")' />
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					Currently open?
					</blockquote> 
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:isCurrentlyOpen = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:isCurrentlyOpen = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No	
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					Date Direct Payment Initiated/Filed 
					or Trustee Appointed (MM/DD/YYYY):
					</blockquote> 
				</td>
				<td>	
					<div class="fakeBox2">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:dateDirectPayment/p1:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					Specify if Date Direct Payment Initiated/Filed or 
					Trustee Appointed is Exact or needs an Explanation
					</blockquote>
				</td>
				<td>	
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:dateDirectPayment/p1:exactOrExplanation='Exact'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Exact	
					<xsl:choose>
						<xsl:when test="p4:BankruptcySipcDrpPartTwo/p4:dateDirectPayment/p1:exactOrExplanation='Explanation'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Explanation	
				</td>
			</tr>
			<xsl:if test="p4:BankruptcySipcDrpPartTwo/p4:dateDirectPayment/p1:exactOrExplanation='Explanation'">
				<tr>
					<td class="label">
						<blockquote>
						<blockquote>
							If not exact, provide explanation:
						</blockquote>
						</blockquote> 
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:dateDirectPayment/p1:explanationInfo"/>
						</div>
					</td>
				</tr>	
			</xsl:if>
			<tr>
				<td class="label">
					10. Provide details of any status/disposition. 
					Include details of creditors, terms, conditions, 
					amounts due and settlement schedule (if applicable). 
					(The information must fit within the space provided.) 
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:BankruptcySipcDrpPartTwo/p4:detailsOfDisposition"/>
					</div>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>