<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:p="http://www.sec.gov/edgar/sbse/sbseafiler"
	xmlns:p1="http://www.sec.gov/edgar/common"
	xmlns:p4="http://www.sec.gov/edgar/sbse_a_drp">

	<!-- Parents templates -->
	<xsl:template name="sbse-a_tab_drp2_regulatoryAction">
		<xsl:if test="count(p:formData/p:regulatoryDrpInfo/p4:regulatoryDrp) &gt; 0">
			<h1>REGULATORY ACTION DISCLOSURE REPORTING PAGE (SBSE-A)</h1>
			<h4 class="title1"><em>GENERAL INSTRUCTIONS</em></h4>
			<div class="information">
				<p>
					You must provide a valid response to each question on every section of this DRP before 
					any of your information can be saved. Invalid or incomplete responses will prevent you 
					from closing the DRP with your information saved. It is recommended that you consult 
					the Print Form of this DRP to make sure you have gathered all the required information 
					before beginning your entry of information online.			
				</p>			
			</div>

			<xsl:call-template name="sbse-a_drp2_regulatoryAction"/>
		</xsl:if>	
	</xsl:template>
	
	<!-- Child templates for SBSE-A -->
	<xsl:template name="sbse-a_drp2_regulatoryAction">
		<xsl:for-each select="p:formData/p:regulatoryDrpInfo/p4:regulatoryDrp">
			<xsl:call-template name="sbse-a_drp2_general"/>

			<xsl:call-template name="sbse-a_drp2_part1"/>

			<xsl:if test="p4:regulatoryDrpPartOne/p4:isSubmittedToCRD = 'N'">
				<xsl:call-template name="sbse-a_drp2_part2"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="sbse-a_drp2_general">
		<!-- VARIABLES BEGIN -->
		<xsl:variable name="sbse-a_drp2_itemAB_14C1">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14C(1)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14C2">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14C(2)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14C3">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14C(3)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14C4">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14C(4)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14C5">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14C(5)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14D1">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14D(1)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14D2">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14D(2)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14D3">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14D(3)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14D4">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14D(4)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14D5">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14D(5)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14E1">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14E(1)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14E2">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14E(2)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14E3">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14E(3)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14E4">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14E(4)'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14F">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14F'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<xsl:variable name="sbse-a_drp2_itemAB_14G">
			<xsl:for-each select="p4:respondingTo/p4:responseQuestion">
				<xsl:if test=". = '14G'">
					<xsl:value-of select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:variable>
		<!-- VARIABLES END -->
		<table role="presentation">
			<tr>
				<td class="label">
					This Disclosure Reporting Page (DRP FP) is an INITIAL <b><em>OR</em></b> AMENDED 
					response to report details for affirmative responses to 
					<em><b>Items C, D, E, F, or G</b></em> of Schedule D of Form SBSE-A;
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:initialOrAmended = 'INITIAL'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;INITIAL
					<xsl:choose>
						<xsl:when test="p4:initialOrAmended = 'AMENDED'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;AMENDED	
				</td>
			</tr>
			<tr>
				<td class="label">
					Check item(s) being responded to: 
				</td>
				<td></td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					C. Has the U.S. Securities and Exchange Commission 
					or the Commodity Futures Trading Commission ever:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14C1 = '14C(1)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) Found the principal to have
					 made a false statement or omission?<br/>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14C2 = '14C(2)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) Found the principal to have been involved in a 
					violation of its regulations or statutes?<br/>						
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14C3 = '14C(3)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(3) the principal to have been a cause of an investment-related 
					business having its authorization to do business denied, revoked, or restricted?<br/>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14C4 = '14C(4)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(4) Entered an order against the 
					principal in connection with investment-related activity?<br/>					
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14C5 = '14C(5)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(5) Imposed a civil money penalty on the principal, 
					or ordered the principal to cease and desist from any activity?				
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					D. Has any other federal regulatory agency, state regulatory agency, or foreign financial regulatory authority:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14D1 = '14D(1)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) Ever found the principal to have made a false statement or omission or been dishonest, unfair, or unethical?<br/>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14D2 = '14D(2)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) Ever found the principal to have been involved in a violation of investment-related regulations or statutes?<br/>						
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14D3 = '14D(3)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(3) Ever found the principal to have been a cause of an investment-related business having its authorization 
					to do business denied, suspended, revoked or
					restricted?<br/>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14D4 = '14D(4)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(4) In the past ten years, entered an order against the principal in connection with an investment-related activity?<br/>					
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14D5 = '14D(5)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(5) Ever denied, suspended, or revoked the principal's registration or license or otherwise, by order, 
					prevented it from associating with an investment-related business or restricted its activities?							
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					E. Has any self-regulatory organization or commodities exchange ever:
					</blockquote>
				</td>
				<td>
				<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14E1 = '14E(1)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(1) found the principal to have made a false statement or omission?<br/>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14E2 = '14E(2)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(2) found the principal to have been involved in a violation of its rules (other than a 
					violation designated as a "minor rule violation" under a plan approved by the
					U.S. Securities and exchange Commission)?<br/>						
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14E3 = '14E(3)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(3) found the principal to have been the cause of an investment-related business 
					having its authorization to do business denied, suspended, revoked or restricted?<br/>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14E4 = '14E(4)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;(4) Disciplined the principal by expelling or suspending it from membership, barring or 
					suspending its association with other members, or otherwise restricting its
					activities?					
				</td>
			</tr>	
			<tr>
				<td class="label">
					<blockquote>
					F.
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14F = '14F'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Has the principal's authorization to act as an attorney, accountant, 
					or federal contractor ever been revoked or suspended?
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
					G.			
					</blockquote>	
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_itemAB_14G = '14G'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Is the principal now the subject of any regulatory proceeding that 
					could result in a "yes" answer to any part of C, D, or E?
				</td>
			</tr>
		</table>
		<div class="information">
			<p>
				Use a separate DRP for each event or <em>proceeding</em>. An event or <em>proceeding</em> may be 
				reported for more than one person or entity using one DRP. File with a completed Execution Page.
				<br/><br/>
				One event may result in more than one affirmative answer to Items C, D, E, F or G. Use only one 
				DRP to report details related to the same event. If an event gives rise to actions by more than 
				one regulator, provide details for each action on a separate DRP.
				<br/><br/>			
				It is not a requirement that documents be provided for each event or proceeding. Should they be 
				provided, they will not be accepted as disclosure in lieu of answering the questions on this DRP.
				<br/><br/>
				If the principal is an organization registered through the CRD, such principal need only complete 
				Part I of the <em>applicant'</em>s appropriate DRP (SBSE). Details of the event must be submitted 
				on the <em>principal'</em>s appropriate DRP (BD) or DRP (U-4). If a principal is an organization 
				<u>not</u> registered through the CRD, provide complete answers to all the items on the <em>applicant'</em>s 
				appropriate DRP (SBSE). The completion of this DRP does not relieve the <em>principal</em> of its obligation 
				to update its CRD records.
			</p>
		</div>
	</xsl:template>
	<xsl:template name="sbse-a_drp2_part1">
		<h4 class="title1">PART I</h4>
		<table role="presentation">
			<tr>
				<td class="label">
					A. If the <em>principal</em> is registered with the CRD, provide the CRD number. 
					If not, indicate "non-registered" by checking the appropriate checkbox.
				</td>
				<td></td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Name of <em>Principal</em>
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:regulatoryDrpPartOne/p4:nameOfPrincipal"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						<em>Principal'</em>s CRD Number
					</blockquote>
				</td>
				<td>
					<div class="fakeBox2">	
						<xsl:value-of select="p4:regulatoryDrpPartOne/p4:crdNumber"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Is the principal registered
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartOne/p4:isRegistered = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartOne/p4:isRegistered = 'N'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
			<xsl:if test="contains($submissionType , '/A')">
				<tr>
					<td class="label">
						<blockquote>
							Is this DRP an amendment that seeks to remove a previously filed DRP concerning the principal from the record?
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="p4:regulatoryDrpPartOne/p4:isShouldBeRemoved = 'Y'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Yes
						<xsl:choose>
							<xsl:when test="p4:regulatoryDrpPartOne/p4:isShouldBeRemoved = 'N'">
								<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;No
					</td>
				</tr>
				<xsl:if test="p4:regulatoryDrpPartOne/p4:isShouldBeRemoved = 'Y'">
					<tr>
						<td class="label">	
							<blockquote>
							<blockquote>
								If "Yes," the reason the DRP should be removed is:
							</blockquote>
							</blockquote>
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="contains(p4:regulatoryDrpPartOne/p4:drpRemovalReason , 'is no longer')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The principal is no longer associated with the SBS Entity.<br/>
							<xsl:choose>
								<xsl:when test="contains(p4:regulatoryDrpPartOne/p4:drpRemovalReason , 'was resolved in')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or <em>proceeding</em> previously reported was resolved in the principal's favor.<br/>
							<xsl:choose>
								<xsl:when test="contains(p4:regulatoryDrpPartOne/p4:drpRemovalReason , 'proceeding occurred')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The event or proceeding occurred more than ten years ago.<br/>
							<xsl:choose>
								<xsl:when test="contains(p4:regulatoryDrpPartOne/p4:drpRemovalReason , 'error')">
									<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
								</xsl:otherwise>
							</xsl:choose>&#160;The DRP was filed in error. 				
						</td>
					</tr>
					<xsl:if test="contains(p4:regulatoryDrpPartOne/p4:drpRemovalReason , 'error')">
						<tr>
							<td class="label">	
								<blockquote>
									<blockquote>
										<blockquote>
											Explain the circumstances:
										</blockquote>
									</blockquote>
								</blockquote>
							</td>
							<td>
								<div class="fakeBox3">
									<xsl:value-of select="p4:regulatoryDrpPartOne/p4:explainCircumstances"/>
								</div>
							</td>
						</tr>		
					</xsl:if>
				</xsl:if>
			</xsl:if>
			<tr>
				<td class="label">
					B. If the <em>principal</em> is registered through the CRD, has the <em>principal</em> 
					submitted a DRP (with Form U-4) or DRP (BD) to the CRD System for the event?
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartOne/p4:isSubmittedToCRD = 'Y'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Yes
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartOne/p4:isSubmittedToCRD = 'N'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No
				</td>
			</tr>
		</table>	
		
		<div class="information">
			<p>
				If the answer is "Yes," no other information on this DRP must be provided: If "No," complete Part II.
				<br/>
				<b>Note:</b> The completion of this Form does <u>not</u> relieve the control affiliate of its obligation to update its CRD records.			
			</p>
		</div>
	</xsl:template>	
	<xsl:template name="sbse-a_drp2_part2">
		<h4 class="title1">PART II</h4>	
		<table role="presentation">
			<tr>
				<td class="label">
					1. Regulatory Action initiated by:
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:regulatoryActionInitiatedBy = 'SEC'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;SEC&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:regulatoryActionInitiatedBy = 'Other Federal'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other Federal&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:regulatoryActionInitiatedBy = 'State'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;State&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:regulatoryActionInitiatedBy = 'SRO'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;SRO&#160;&#160;
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:regulatoryActionInitiatedBy = 'Foreign'">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Foreign																
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						(Full name of regulator, foreign financial 
						regulatory authority, federal, state or SRO)
					</blockquote>
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:regulatorName"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					2.  Principal Sanction: (check appropriate item)
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Administrative')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Civil and Administrative Penalty(ies)/Fine(s)<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Bar')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Bar<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Desist')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Cease and Desist<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Censure')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Censure<br/>		
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Denial')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Denial<br/>		
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Disgorgement')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Disgorgement<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Expulsion')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Expulsion<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Injunction')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Injunction<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Prohibition')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Prohibition<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Reprimand')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Reprimand<br/>		
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Restitution')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restitution<br/>			
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Revocation')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Revocation<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Suspension')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Suspension<br/>		
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Undertaking')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Undertaking<br/>		
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Other')">
							<img src="Images/radio-checked.jpg"   alt="Radio button checked"/>
						</xsl:when>
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other
				</td>
			</tr>	
			<xsl:if test="contains(p4:regulatoryDrpPartTwo/p4:principalSanction , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanctionDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<!-- VARIABLES BEGIN -->
			<xsl:variable name="sbse-a_drp2_part2_2_1">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Civil')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_2">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Bar')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_3">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Cease')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_4">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Censure')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_5">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Denial')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_6">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Disgorgement')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_7">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Expulsion')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_8">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Injunction')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_9">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Prohibition')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_10">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Reprimand')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_11">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Restitution')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_12">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Revocation')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_13">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Suspension')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_14">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , 'Undertaking')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part2_2_15">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalSanction">
					<xsl:if test="contains(. , '')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES END -->
			<tr>
				<td class="label">
					<blockquote>
						Other Sanctions:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_1 , 'Administrative')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Civil and Administrative Penalty(ies)/Fine(s)<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_2 , 'Bar')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Bar<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_3 , 'Desist')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Cease and Desist<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_4 , 'Censure')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Censure<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_5 , 'Denial')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Denial<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_6 , 'Disgorgement')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Disgorgement<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_7 , 'Expulsion')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Expulsion<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_8 , 'Injunction')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Injunction<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_9 , 'Prohibition')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Prohibition<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_10 , 'Reprimand')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Reprimand<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_11 , 'Restitution')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Restitution<br/>			
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_12 , 'Revocation')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Revocation<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_13 , 'Suspension')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Suspension<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_14 , 'Undertaking')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Undertaking<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part2_2_15 , 'Other')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other
				</td>
			</tr>
			<xsl:if test="contains($sbse-a_drp2_part2_2_15 , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:otherSanctionsDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>			
			<tr>
				<td class="label">
					3.  Date Initiated (MM/DD/YYYY)
				</td>
				<td>
					<div class="fakeBox2">
						<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:dateInitiated/p1:date"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					<blockquote>
						Specify if Date Initiated is Exact or needs an Explanation
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:dateInitiated/p1:exactOrExplanation , 'Exact')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Exact	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:dateInitiated/p1:exactOrExplanation , 'Explanation')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Explanation					
				</td>
			</tr>
			<xsl:if test="contains(p4:regulatoryDrpPartTwo/p4:dateInitiated/p1:exactOrExplanation , 'Explanation')">
				<tr>
					<td class="label">
						<blockquote>
							If not exact, provide explanation:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:dateInitiated/p1:explanationInfo"/>
						</div>
					</td>
				</tr>	
			</xsl:if>
			<tr>
				<td class="label">
					4.Docket/Case Number:
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:docketOrCaseNumber"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					5. Principal Employing Firm when activity occurred which led to the regulatory action (if applicable):
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:controlAffiliateEmployingFirm"/>
					</div>
				</td>
			</tr>	
			<tr>
				<td class="label">
					6. Principal Product Type: (check appropriate item)
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Fixed')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) – Fixed<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Variable')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) – Variable<br/>													
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Banking Products')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Banking Products (other than CD(s))<br/>		
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:principalProductType = 'CD(s)'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;CD(s)<br/>		
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Commodity Option')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Option(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Asset Backed')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Asset Backed<br/>							
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Corporate')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Corporate<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Government')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Government<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Municipal')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Municipal<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Derivative')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Derivative(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'LP Interest(s)')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Direct Investment(s) - DPP &amp; LP Interest(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'OTC')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity - OTC<br/>							
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Equity Listed')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity Listed (Common &amp; Preferred Stock)<br/>						
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Commodity')
									and contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Futures')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Commodity<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Financial')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Financial<br/>								
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Index Option')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Index  Option(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Insurance')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Insurance<br/>							
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Investment Contract')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Investment Contract(s)<br/>								
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Money Market')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Market Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Mutual Fund')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Mutual Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'No Product')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No Product<br/>		
					<xsl:choose>
						<xsl:when test="p4:regulatoryDrpPartTwo/p4:principalProductType = 'Options'">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Options<br/>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Penny Stock')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Penny Stock(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Unit Investment')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Unit Investment Trust(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Other')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other						
				</td>
			</tr>
			<xsl:if test="contains(p4:regulatoryDrpPartTwo/p4:principalProductType , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:principalProductTypeOtherDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>
			<!-- VARIABLES BEGIN -->
			<xsl:variable name="sbse-a_drp2_part6_1">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Fixed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_2">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Variable')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_3">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Banking Products')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_4">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test=". = 'CD(s)'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_5">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Commodity Option')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_6">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Asset Backed')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_7">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Corporate')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_8">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Government')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_9">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Municipal')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_10">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Derivative')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_11">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Direct Investment')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_12">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'OTC')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_13">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Preferred Stock')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_14">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Futures - Commodity')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_15">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Futures - Financial')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_16">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Index Option')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_17">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test=". = 'Insurance'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_18">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Investment Contract')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_19">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Money Market Fund')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_20">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Mutual Fund')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_21">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test=". = 'No Product'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_22">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test=". = 'Options'">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_23">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Penny Stock')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_24">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Unit Investment Trust')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="sbse-a_drp2_part6_25">
				<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:otherPrincipalProductType">
					<xsl:if test="contains(. , 'Other')">
						<xsl:value-of select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<!-- VARIABLES END -->
			<tr>
				<td class="label">
					<blockquote>
						Other Product Type:
					</blockquote>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_1 , 'Fixed')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Fixed<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_2 , 'Variable')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Annuity(ies) - Variable<br/>													
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_3 , 'Banking Products')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Banking Products (other than CD(s))<br/>		
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_part6_4 = 'CD(s)'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;CD(s)<br/>		
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_5 , 'Commodity Option')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Commodity Option(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_6 , 'Asset Backed')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Asset Backed<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_7 , 'Corporate')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Corporate<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_8 , 'Government')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Government<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_9 , 'Municipal')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Debt - Municipal<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_10 , 'Derivative')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Derivative(s)<br/>						
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_11 , 'LP Interest(s)')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Direct Investment(s) - DPP &amp; LP Interest(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_12 , 'OTC')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity - OTC<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_13 , 'Equity Listed')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Equity Listed (Common &amp; Preferred Stock)<br/>						
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_14 , 'Commodity')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Commodity<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_15 , 'Financial')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Futures - Financial<br/>								
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_16 , 'Index Option')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Index Option(s)<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_17 , 'Insurance')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Insurance<br/>							
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_18 , 'Investment Contract')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Investment Contract(s)<br/>								
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_19 , 'Money Market')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Money Market Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_20 , 'Mutual Fund')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Mutual Fund(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_21 , 'No Product')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;No Product<br/>		
					<xsl:choose>
						<xsl:when test="$sbse-a_drp2_part6_22 = 'Options'">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Options<br/>
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_23 , 'Penny Stock')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Penny Stock(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_24 , 'Unit Investment')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Unit Investment Trust(s)<br/>	
					<xsl:choose>
						<xsl:when test="contains($sbse-a_drp2_part6_25 , 'Other')">
							<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Other					
				</td>
			</tr>
			<xsl:if test="contains($sbse-a_drp2_part6_25 , 'Other')">
				<tr>
					<td class="label">
						<blockquote>
							If Other is selected, please describe
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:otherProductDesc"/>
						</div>
					</td>
				</tr>
			</xsl:if>			
			<tr>
				<td class="label">
					7. Describe the allegations related to this regulatory action. (The information must fit within the space provided.):
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:descAllegations"/>
					</div>
				</td>
			</tr>
			<tr>
				<td class="label">
					8. Current Status ?				
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:currentStatus , 'Pending')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Pending&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:currentStatus , 'Appeal')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;On Appeal&#160;&#160;
					<xsl:choose>
						<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:currentStatus , 'Final')">
							<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
						</xsl:when>											
						<xsl:otherwise>
							<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
						</xsl:otherwise>
					</xsl:choose>&#160;Final						
				</td>
			</tr>
			<xsl:if test="contains(p4:regulatoryDrpPartTwo/p4:currentStatus , 'Appeal')">	
				<tr>
					<td class="label">
						9. If on appeal, regulatory action appealed to: 
						(SEC, SRO, Federal or State Court):
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:appealedTo , 'SEC')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;SEC&#160;&#160;
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:appealedTo , 'SRO')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;SRO&#160;&#160;
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:appealedTo , 'Federal')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Federal Court&#160;&#160;	
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:appealedTo , 'State')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;State Court&#160;&#160;						
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:appealedTo , 'Other')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Other
					</td>
				</tr>
				<xsl:if test="contains(p4:regulatoryDrpPartTwo/p4:appealedTo , 'Other')">
					<tr>
						<td class="label">
							<blockquote>
								If Other is selected, please describe
							</blockquote>
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:otherDescribe"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						<blockquote>
							and Date Appeal Filed:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:dateAppealFiled"/>
						</div>
					</td>
				</tr>	
			</xsl:if>
			<xsl:if test="not(contains(p4:regulatoryDrpPartTwo/p4:currentStatus , 'Pending'))">
				<tr>
					<td class="label">
						<h4>If Final or On Appeal, complete all items below. 
						For Pending Actions, complete Item 13 only.</h4>
					</td>
					<td></td>
				</tr>
				<tr>
					<td class="label">
						10. How was matter resolved: (check appropriate item)
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:matterResolvedType , 'Acceptance')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Acceptance, Waiver &amp; Consent (AWC)<br/>	
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:matterResolvedType , 'Settlement')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Decision &amp; Order of Offer of Settlement<br/>
						<xsl:choose>
							<xsl:when test="p4:regulatoryDrpPartTwo/p4:matterResolvedType = 'Decision'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Decision<br/>	
						<xsl:choose>
							<xsl:when test="p4:regulatoryDrpPartTwo/p4:matterResolvedType = 'Consent'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Consent<br/>								
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:matterResolvedType , 'Dismissed')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Dismissed<br/>	
						<xsl:choose>
							<xsl:when test="p4:regulatoryDrpPartTwo/p4:matterResolvedType = 'Order'">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Order<br/>
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:matterResolvedType , 'Settled')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Settled<br/>	
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:matterResolvedType , 'Stipulation')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Stipulation and Consent<br/>								
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:matterResolvedType , 'Vacated')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Vacated							
					</td>
				</tr>
				<tr>
					<td class="label">
						11. Resolution Date (MM/DDIYYYY)
					</td>
					<td>
						<div class="fakeBox2">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:resolutionDate/p1:date"/>
						</div>
					</td>
				</tr>	
				<tr>
					<td class="label">
						<blockquote>
							Specify if Resolution Date is Exact or needs an Explanation:
						</blockquote>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:resolutionDate/p1:exactOrExplanation , 'Exact')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Exact
						<xsl:choose>
							<xsl:when test="contains(p4:regulatoryDrpPartTwo/p4:resolutionDate/p1:exactOrExplanation , 'Explanation')">
								<img src="Images/radio-checked.jpg" alt="Radio button checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/radio-unchecked.jpg" alt="Radio button not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Explanation						
					</td>
				</tr>	
				<xsl:if test="contains(p4:regulatoryDrpPartTwo/p4:resolutionDate/p1:exactOrExplanation , 'Explanation')">
					<tr>
						<td class="label">
							<blockquote>
								If not exact, provide explanation:
							</blockquote>  
						</td>
						<td>
							<div class="fakeBox3">
								<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:resolutionDate/p1:explanationInfo"/>
							</div>
						</td>
					</tr>
				</xsl:if>
				<!-- VARIABLES BEGIN -->
				<xsl:variable name="sbse-a_drp2_item12a">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Monetary')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_drp2_item12b">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Revocation')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_drp2_item12c">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Censure')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_drp2_item12d">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Cease and Desist')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_drp2_item12e">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Disgorgement')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_drp2_item12f">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Bar')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="sbse-a_drp2_item12g">
					<xsl:for-each select="p4:regulatoryDrpPartTwo/p4:sanctionsOrdered/p4:sanctionOrdered">
						<xsl:if test="contains(., 'Suspension')">
							<xsl:value-of select="."/>
						</xsl:if>
					</xsl:for-each>
				</xsl:variable>
				<!-- VARIABLES END -->
				<tr>
					<td class="label">
						12. A. Were any of the following Sanctions 
						Ordered? (Check all appropriate items):
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12a , 'Monetary')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Monetary/Fine<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12b , 'Revocation')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Revocation/Expulsion/Denial<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12c , 'Censure')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Censure<br/>		
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12d , 'Cease')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Cease and Desist/Injunction<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12e , 'Disgorgement')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Disgorgement/Restitution<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12f , 'Bar')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Bar<br/>	
						<xsl:choose>
							<xsl:when test="contains($sbse-a_drp2_item12g , 'Suspension')">
								<img src="Images/box-checked.jpg" alt="Checkbox checked"/>
							</xsl:when>											
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked"/>
							</xsl:otherwise>
						</xsl:choose>&#160;Suspension				
					</td>
				</tr>
				<xsl:if test="contains($sbse-a_drp2_item12a , 'Monetary')">	
					<tr>
						<td class="label">
							<blockquote>
							<blockquote>
							Amount:
							</blockquote>
							</blockquote>
						</td>
						<td>
							<div class="fakeBox2">
								<xsl:value-of select='format-number(p4:regulatoryDrpPartTwo/p4:monetaryFineAmount , "$###,###,###,##0.00")' />
							</div>
						</td>
					</tr>
				</xsl:if>
				<tr>
					<td class="label">
						<blockquote>
						B. Other Sanctions Ordered:
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:otherSanctionsOrdered"/>
						</div>
					</td>
				</tr>
				<tr>
					<td class="label">
						<blockquote>
						C. Sanction Detail:  If suspended, enjoined or barred, provide duration including start date and 
						capacities affected (General Securities Principal, Financial Operations Principal, etc.).  
						If requalification, by exam/retraining was a condition of the sanction, provide length of time 
						given to re-qualify/retrain, type of exam required and whether condition has been satisfied.  
						If disposition resulted in a fine, penalty, restitution, disgorgement or monetary compensation, 
						provide total amount, portion levied against principal, date paid and if any portion of penalty was waived.
						</blockquote>
					</td>
					<td>
						<div class="fakeBox3">
							<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:sanctionDetail"/>
						</div>
					</td>
				</tr>
			</xsl:if>	
	
			<tr>
				<td class="label">
					13. Provide a brief summary of details related to the action status and (or) disposition and include relevant terms, conditions and dates. (The information must fit within the space provided.)
				</td>
				<td>
					<div class="fakeBox3">
						<xsl:value-of select="p4:regulatoryDrpPartTwo/p4:summaryOfDetails"/>
					</div>
				</td>
			</tr>			
		</table>	
	</xsl:template>
</xsl:stylesheet>